/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging.introspect;

import edu.berkeley.guir.lib.debugging.introspect.IntrospectConstants;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

public class IntrospectLib
implements IntrospectConstants {
    private IntrospectLib() {
    }

    public static List getAllFields(Class cl) {
        return IntrospectLib.getAllFields(cl, new LinkedList());
    }

    private static List getAllFields(Class cl, List l) {
        Field[] fields = cl.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            l.add(fields[i]);
            ++i;
        }
        Class parent = cl.getSuperclass();
        if (parent != null && !parent.isInterface() && !parent.isPrimitive()) {
            IntrospectLib.getAllFields(parent, l);
        }
        return l;
    }

    public static String getModString(int mods) {
        String str = Modifier.toString(mods);
        if (str.length() > 0) {
            return String.valueOf(str) + " ";
        }
        return str;
    }

    public static String getTypeString(Class cl) {
        if (cl.isArray()) {
            return IntrospectLib.getArrayStringName(cl);
        }
        return cl.getName();
    }

    public static String getArrayStringName(Class type) {
        if (!type.isArray()) {
            return "";
        }
        String strType = type.getName();
        int arrcount = 0;
        String strReturn = null;
        int i = 0;
        while (i < strType.length()) {
            switch (strType.charAt(i)) {
                case '[': {
                    ++arrcount;
                    break;
                }
                case 'L': {
                    strReturn = strType.substring(i + 1, strType.length() - 1);
                    break;
                }
                case 'Z': {
                    strReturn = "boolean";
                    break;
                }
                case 'C': {
                    strReturn = "char";
                    break;
                }
                case 'B': {
                    strReturn = "byte";
                    break;
                }
                case 'S': {
                    strReturn = "short";
                    break;
                }
                case 'I': {
                    strReturn = "int";
                    break;
                }
                case 'J': {
                    strReturn = "long";
                    break;
                }
                case 'F': {
                    strReturn = "float";
                    break;
                }
                case 'D': {
                    strReturn = "double";
                    break;
                }
                default: {
                    strReturn = "unknown";
                }
            }
            if (strReturn != null) break;
            ++i;
        }
        i = 0;
        while (i < arrcount) {
            strReturn = String.valueOf(strReturn) + "[]";
            ++i;
        }
        return strReturn;
    }
}

