/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging.introspect;

import edu.berkeley.guir.lib.debugging.introspect.IntrospectConstants;
import edu.berkeley.guir.lib.debugging.introspect.IntrospectHandler;
import edu.berkeley.guir.lib.debugging.introspect.IntrospectLib;
import edu.berkeley.guir.lib.debugging.introspect.PrintIntrospectHandler;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Introspect
implements IntrospectConstants {
    static HashSet setTraversed = new HashSet();

    private static void parseField(Field f, Object obj, int depth, IntrospectHandler handler) {
        Class<?> clField = f.getType();
        if (!handler.acceptField(depth, f, obj)) {
            return;
        }
        try {
            if (clField.isArray()) {
                Object fval = f.get(obj);
                if (fval != null) {
                    handler.onArray(depth, f, fval);
                } else {
                    handler.onNull(depth, f);
                }
            } else if (clField.toString().startsWith("class")) {
                Object fval = f.get(obj);
                if (fval != null) {
                    handler.onObject(depth, f, fval);
                    if (handler.shouldRecurse(depth, f, fval)) {
                        Introspect.parseObject(fval, depth + 1, handler);
                    }
                } else {
                    handler.onNull(depth, f);
                }
            } else if (clField == Character.TYPE) {
                handler.onChar(depth, f, f.getChar(obj));
            } else if (clField == Boolean.TYPE) {
                handler.onBoolean(depth, f, f.getBoolean(obj));
            } else if (clField == Integer.TYPE) {
                handler.onInt(depth, f, f.getInt(obj));
            } else if (clField == Long.TYPE) {
                handler.onLong(depth, f, f.getLong(obj));
            } else if (clField == Float.TYPE) {
                handler.onFloat(depth, f, f.getFloat(obj));
            } else if (clField == Double.TYPE) {
                handler.onDouble(depth, f, f.getDouble(obj));
            } else if (clField == Short.TYPE) {
                handler.onShort(depth, f, f.getShort(obj));
            } else if (clField == Byte.TYPE) {
                handler.onByte(depth, f, f.getByte(obj));
            }
        }
        catch (IllegalAccessException e) {
            handler.onException(depth, f, e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseObject(Object obj, IntrospectHandler handler) {
        setTraversed.clear();
        handler.onRoot(obj);
        Introspect.parseObject(obj, 1, handler);
    }

    private static void parseObject(Object obj, int depth, IntrospectHandler handler) {
        if (obj == null) {
            return;
        }
        if (setTraversed.contains(obj)) {
            return;
        }
        setTraversed.add(obj);
        List listFields = IntrospectLib.getAllFields(obj.getClass());
        Iterator it = listFields.iterator();
        while (it.hasNext()) {
            Field f = (Field)it.next();
            try {
                f.setAccessible(true);
            }
            catch (SecurityException e) {
                System.err.println(e.toString());
            }
            Introspect.parseField(f, obj, depth, handler);
        }
    }

    public static void main(String[] argv) {
        Introspect.parseObject("dogs", new PrintIntrospectHandler());
        Introspect.parseObject(new PrintIntrospectHandler(), new PrintIntrospectHandler());
    }
}

