/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging.introspect;

import edu.berkeley.guir.lib.debugging.introspect.IntrospectConstants;
import edu.berkeley.guir.lib.debugging.introspect.IntrospectFilter;
import edu.berkeley.guir.lib.debugging.introspect.IntrospectHandler;
import java.lang.reflect.Field;

public abstract class DefaultIntrospectHandler
extends IntrospectHandler {
    public DefaultIntrospectHandler() {
    }

    public DefaultIntrospectHandler(IntrospectFilter f) {
        super(f);
    }

    protected String toString(boolean val) {
        return "" + val;
    }

    protected String toString(char val) {
        return "" + val;
    }

    protected String toString(short val) {
        return "" + val;
    }

    protected String toString(byte val) {
        return "" + val;
    }

    protected String toString(int val) {
        return "" + val;
    }

    protected String toString(long val) {
        return "" + val;
    }

    protected String toString(float val) {
        return "" + val;
    }

    protected String toString(double val) {
        return "" + val;
    }

    protected String toString(Object val) {
        return "" + val;
    }

    protected String toString(boolean[] arr) {
        StringBuffer strbuf = new StringBuffer(7 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(char[] arr) {
        StringBuffer strbuf = new StringBuffer(3 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(short[] arr) {
        StringBuffer strbuf = new StringBuffer(4 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(byte[] arr) {
        StringBuffer strbuf = new StringBuffer(5 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(int[] arr) {
        StringBuffer strbuf = new StringBuffer(7 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(long[] arr) {
        StringBuffer strbuf = new StringBuffer(9 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(float[] arr) {
        StringBuffer strbuf = new StringBuffer(9 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(double[] arr) {
        StringBuffer strbuf = new StringBuffer(11 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(this.toString(arr[i])) + ", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected String toString(Object[] arr) {
        StringBuffer strbuf = new StringBuffer(15 * arr.length + 2);
        strbuf.append("{");
        int i = 0;
        while (i < arr.length) {
            if (arr[i] != null && arr[i].getClass().isArray()) {
                Class<?> cl = arr[i].getClass();
                if (cl == IntrospectConstants.CL_BOOLEAN_ARR) {
                    strbuf.append(this.toString((boolean[])arr[i]));
                } else if (cl == IntrospectConstants.CL_CHAR_ARR) {
                    strbuf.append(this.toString((char[])arr[i]));
                } else if (cl == IntrospectConstants.CL_BYTE_ARR) {
                    strbuf.append(this.toString((byte[])arr[i]));
                } else if (cl == IntrospectConstants.CL_SHORT_ARR) {
                    strbuf.append(this.toString((short[])arr[i]));
                } else if (cl == IntrospectConstants.CL_INT_ARR) {
                    strbuf.append(this.toString((int[])arr[i]));
                } else if (cl == IntrospectConstants.CL_LONG_ARR) {
                    strbuf.append(this.toString((long[])arr[i]));
                } else if (cl == IntrospectConstants.CL_FLOAT_ARR) {
                    strbuf.append(this.toString((float[])arr[i]));
                } else if (cl == IntrospectConstants.CL_DOUBLE_ARR) {
                    strbuf.append(this.toString((double[])arr[i]));
                } else {
                    strbuf.append(this.toString((Object[])arr[i]));
                }
            } else {
                strbuf.append(this.toString(arr[i]));
            }
            strbuf.append(", ");
            ++i;
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected void onBooleanArr(int depth, Field f, boolean[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onCharArr(int depth, Field f, char[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onShortArr(int depth, Field f, short[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onByteArr(int depth, Field f, byte[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onIntArr(int depth, Field f, int[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onLongArr(int depth, Field f, long[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onFloatArr(int depth, Field f, float[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onDoubleArr(int depth, Field f, double[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected void onObjectArr(int depth, Field f, Object[] arr) {
        this.output(depth, f, this.toString(arr));
    }

    protected abstract void output(int var1, Field var2, String var3);

    public void onRoot(Object obj) {
        this.output(0, null, obj.toString());
    }

    public void onObject(int depth, Field f, Object obj) {
        this.output(depth, f, obj.toString());
    }

    public void onArray(int depth, Field f, Object arr) {
        Class<?> cl = arr.getClass();
        if (cl == IntrospectConstants.CL_BOOLEAN_ARR) {
            this.onBooleanArr(depth, f, (boolean[])arr);
        } else if (cl == IntrospectConstants.CL_CHAR_ARR) {
            this.onCharArr(depth, f, (char[])arr);
        } else if (cl == IntrospectConstants.CL_BYTE_ARR) {
            this.onByteArr(depth, f, (byte[])arr);
        } else if (cl == IntrospectConstants.CL_SHORT_ARR) {
            this.onShortArr(depth, f, (short[])arr);
        } else if (cl == IntrospectConstants.CL_INT_ARR) {
            this.onIntArr(depth, f, (int[])arr);
        } else if (cl == IntrospectConstants.CL_LONG_ARR) {
            this.onLongArr(depth, f, (long[])arr);
        } else if (cl == IntrospectConstants.CL_FLOAT_ARR) {
            this.onFloatArr(depth, f, (float[])arr);
        } else if (cl == IntrospectConstants.CL_DOUBLE_ARR) {
            this.onDoubleArr(depth, f, (double[])arr);
        } else {
            this.onObjectArr(depth, f, (Object[])arr);
        }
    }

    public void onNull(int depth, Field f) {
        this.output(depth, f, "null");
    }

    public void onBoolean(int depth, Field f, boolean val) {
        this.output(depth, f, "" + val);
    }

    public void onChar(int depth, Field f, char val) {
        this.output(depth, f, "" + val);
    }

    public void onInt(int depth, Field f, int val) {
        this.output(depth, f, "" + val);
    }

    public void onLong(int depth, Field f, long val) {
        this.output(depth, f, "" + val);
    }

    public void onFloat(int depth, Field f, float val) {
        this.output(depth, f, "" + val);
    }

    public void onDouble(int depth, Field f, double val) {
        this.output(depth, f, "" + val);
    }

    public void onShort(int depth, Field f, short val) {
        this.output(depth, f, "" + val);
    }

    public void onByte(int depth, Field f, byte val) {
        this.output(depth, f, "" + val);
    }
}

