/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;

public class LogSettings {
    public static final String SEVERE = "SEVERE";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    public static final String CONFIG = "CONFIG";
    public static final String FINE = "FINE";
    public static final String FINER = "FINER";
    public static final String FINEST = "FINEST";
    public static final String OFF = "OFF";
    public static final String APACHE_FATAL = "SEVERE";
    public static final String APACHE_ERROR = "SEVERE";
    public static final String APACHE_WARN = "WARNING";
    public static final String APACHE_INFO = "INFO";
    public static final String APACHE_DEBUG = "FINE";
    public static final String APACHE_TRACE = "FINEST";
    Properties props = new Properties();

    public LogSettings() {
        this.init();
        try {
            ByteArrayOutputStream bostream = new ByteArrayOutputStream();
            this.props.store(bostream, null);
            ByteArrayInputStream bistream = new ByteArrayInputStream(bostream.toByteArray());
            LogManager.getLogManager().readConfiguration(bistream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init() {
        this.props.setProperty("handlers", this.getHandlers());
        this.props.setProperty(".level", this.getDefaultLevel());
        this.props.setProperty("java.util.logging.ConsoleHandler.level", this.getConsoleLevel());
        this.props.setProperty("java.util.logging.ConsoleHandler.formatter", this.getConsoleFormatter());
        this.props.setProperty("java.util.logging.FileHandler.pattern", this.getFilePattern());
        this.props.setProperty("java.util.logging.FileHandler.limit", this.getFileLimit());
        this.props.setProperty("java.util.logging.FileHandler.count", this.getFileCount());
        this.props.setProperty("java.util.logging.FileHandler.formatter", this.getFileFormatter());
        Map map = this.getClassLevels();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String strKey = (String)it.next();
            String strVal = (String)map.get(strKey);
            this.props.setProperty(String.valueOf(strKey) + ".level", strVal);
        }
    }

    protected String getHandlers() {
        return "java.util.logging.ConsoleHandler";
    }

    protected String getDefaultLevel() {
        return "INFO";
    }

    protected String getConsoleLevel() {
        return "INFO";
    }

    protected String getConsoleFormatter() {
        return "java.util.logging.SimpleFormatter";
    }

    protected String getFileLevel() {
        return "FINEST";
    }

    protected String getFilePattern() {
        return "%h/java%u.log";
    }

    protected String getFileLimit() {
        return "50000";
    }

    protected String getFileCount() {
        return "1";
    }

    protected String getFileFormatter() {
        return "java.util.logging.XMLFormatter";
    }

    protected Map getClassLevels() {
        return Collections.EMPTY_MAP;
    }

    public static void main(String[] argv) {
    }
}

