/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class LogFile {
    public static final String DEFAULT_LOGFILE = "logfile.txt";
    private static final String EOLN = "\n";
    private PrintWriter fWrite;
    private boolean flagPrintTime = true;
    DateFormat dFormatDate;
    DateFormat dFormatTime;

    public LogFile() throws IOException {
        this(DEFAULT_LOGFILE);
    }

    public LogFile(String strLogFileName) throws IOException {
        this(new PrintWriter(new FileWriter(strLogFileName, true)));
    }

    public LogFile(PrintWriter printWriter) throws IOException {
        this(printWriter, DateFormat.getDateInstance(2), DateFormat.getTimeInstance(3));
    }

    public LogFile(PrintWriter printWriter, DateFormat dFormatDate, DateFormat dFormatTime) throws IOException {
        this.fWrite = printWriter;
        this.dFormatDate = dFormatDate;
        this.dFormatTime = dFormatTime;
    }

    public void finalize() {
        try {
            this.fWrite.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setPrintTime(boolean flag) {
        this.flagPrintTime = flag;
    }

    public boolean shouldPrintTime() {
        return this.flagPrintTime;
    }

    private String getCurrentDateAndTime() {
        if (this.shouldPrintTime()) {
            Date date = new Date();
            return String.valueOf(this.dFormatDate.format(date)) + " " + this.dFormatTime.format(date);
        }
        return "";
    }

    public String getSeverityLevel(int iSeverity) {
        return "" + iSeverity;
    }

    public void close() {
        try {
            this.fWrite.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void logMessage(int iSeverity, String strMessage) {
        String strHeader = "";
        if (this.shouldPrintTime()) {
            strHeader = String.valueOf(this.getCurrentDateAndTime()) + " " + this.getSeverityLevel(iSeverity) + " - ";
        }
        String strOut = String.valueOf(strHeader) + strMessage + EOLN;
        this.fWrite.write(strOut);
        if (this.fWrite.checkError()) {
            System.err.println("Error in writing to logfile");
        }
    }

    public void logMessage(String strMessage) {
        String strHeader = "";
        if (this.shouldPrintTime()) {
            strHeader = String.valueOf(this.getCurrentDateAndTime()) + "   - ";
        }
        String strOut = String.valueOf(strHeader) + strMessage + EOLN;
        this.fWrite.write(strOut);
        if (this.fWrite.checkError()) {
            System.err.println("Error in writing to logfile");
        }
    }
}

