/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import edu.berkeley.guir.lib.io.IOLib;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FindInClassPath {
    static /* synthetic */ Class class$0;

    private static String[] parseClassName(String strClassName) {
        StringTokenizer strtok = new StringTokenizer(strClassName, ".");
        LinkedList<String> listPath = new LinkedList<String>();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (!strtok.hasMoreTokens()) {
                token = String.valueOf(token) + ".class";
            }
            listPath.add(token);
        }
        return listPath.toArray(new String[0]);
    }

    private static String toClassFileName(String strClassName) {
        String[] strParsedClassName = FindInClassPath.parseClassName(strClassName);
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < strParsedClassName.length) {
            if (i > 0) {
                strbuf.append("/");
            }
            strbuf.append(strParsedClassName[i]);
            ++i;
        }
        return strbuf.toString();
    }

    public static List getClassPath() {
        String strClassPath = System.getProperty("java.class.path");
        LinkedList<String> listPaths = new LinkedList<String>();
        StringTokenizer strtok = new StringTokenizer(strClassPath, ";");
        while (strtok.hasMoreTokens()) {
            String strPath = strtok.nextToken();
            listPaths.add(strPath);
        }
        return listPaths;
    }

    public static List checkClassPath(String strClassName) {
        return FindInClassPath.checkClassPath(FindInClassPath.getClassPath(), strClassName);
    }

    private static List checkClassPath(List listPaths, String strClassName) {
        String strClassFileName = FindInClassPath.toClassFileName(strClassName);
        Iterator it = listPaths.iterator();
        LinkedList<String> listGoodPaths = new LinkedList<String>();
        System.out.println("Searching for " + strClassName + " in same order as classpath");
        while (it.hasNext()) {
            String strPath = (String)it.next();
            if (!FindInClassPath.checkClassPath(strPath, strClassFileName)) continue;
            listGoodPaths.add(strPath);
        }
        return listGoodPaths;
    }

    public static List checkClassPath(Class cl) {
        return FindInClassPath.checkClassPath(FindInClassPath.getClassPath(), cl.getName());
    }

    private static List checkClassPath(List listPaths, Class cl) {
        return FindInClassPath.checkClassPath(FindInClassPath.getClassPath(), cl.getName());
    }

    private static String chop(String strClassFileName) {
        int index = strClassFileName.lastIndexOf(".");
        return strClassFileName.substring(index + 1);
    }

    private static boolean checkClassPath(String strPath, String strClassFileName) {
        System.out.println("   Searching " + strPath);
        if (strPath.endsWith(".zip") || strPath.endsWith(".jar")) {
            try {
                ZipFile zipfile = new ZipFile(strPath);
                Enumeration<? extends ZipEntry> en = zipfile.entries();
                while (en.hasMoreElements()) {
                    String str = ((Object)en.nextElement()).toString();
                    if (!str.endsWith(strClassFileName)) continue;
                    System.out.println("      " + str);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
        if (!strPath.endsWith(File.separator)) {
            strPath = String.valueOf(strPath) + File.separator;
        }
        strPath = strPath.replaceAll("\\\\", "/");
        File f = new File(strPath = String.valueOf(strPath) + strClassFileName);
        if (f.exists()) {
            System.out.println("      " + f.toString());
            return true;
        }
        File[] files = IOLib.getAllFiles(new File(strPath));
        boolean flagFound = false;
        int i = 0;
        while (i < files.length) {
            if (files[i].toString().endsWith(strPath)) {
                System.out.println("      " + files[i].toString());
                flagFound = true;
            }
            ++i;
        }
        return flagFound;
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Find where in the classpath a class is being loaded");
        System.out.println("Usage:");
        StringBuffer stringBuffer = new StringBuffer("   java ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.debugging.FindInClassPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer.append(clazz.getName()).append(" [class]").toString());
        System.out.println();
        System.out.println("Example:");
        StringBuffer stringBuffer2 = new StringBuffer("   java ");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.lib.debugging.FindInClassPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer2.append(clazz2.getName()).append(" java.lang.Object").toString());
        StringBuffer stringBuffer3 = new StringBuffer("   java ");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("edu.berkeley.guir.lib.debugging.FindInClassPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer3.append(clazz3.getName()).append(" Object").toString());
    }

    public static void main(String[] argv) {
        if (argv.length <= 0) {
            FindInClassPath.printUsage();
            System.exit(0);
        }
        List listPaths = FindInClassPath.checkClassPath(argv[0]);
        System.out.println();
        if (listPaths.size() <= 0) {
            System.out.println(String.valueOf(argv[0]) + " not found");
        }
    }
}

