/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugWindow
extends JFrame {
    public static final String PROMPT = "";
    private static JTextArea text = new JTextArea(50, 90);

    public DebugWindow() {
        this("Application");
        this.newPrompt();
        text.append(PROMPT);
    }

    public DebugWindow(String strAppName) {
        super(String.valueOf(strAppName) + " Debugging Window");
        this.setSize(600, 800);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", new JScrollPane(text));
        text.setAutoscrolls(true);
        this.addWindowListener(new DebugWindowListener());
        JButton b = new JButton("Clear Screen");
        this.getContentPane().add("South", b);
        b.addActionListener(new DebugWindowButtonListener());
        this.setFont(new Font("Monospaced", 0, 12));
        text.setFont(new Font("Monospaced", 0, 12));
        this.show();
    }

    private void updatePosition() {
        text.setCaretPosition(text.getText().length());
    }

    private void newPrompt() {
        text.append("\n");
    }

    public void close() {
        this.dispose();
    }

    public void clear() {
        text.setText(PROMPT);
        this.updatePosition();
    }

    public void print(Object obj) {
        if (this.isVisible()) {
            text.append(obj.toString());
            this.updatePosition();
        }
    }

    public void println() {
        if (this.isVisible()) {
            text.append("\n");
            this.updatePosition();
        }
    }

    public void println(Object obj) {
        if (this.isVisible()) {
            text.append(String.valueOf(obj.toString()) + "\n");
            this.updatePosition();
        }
    }

    public void finalize() {
        this.dispose();
    }

    public static void main(String[] argv) {
        DebugWindow dwnd = new DebugWindow();
    }

    class DebugWindowButtonListener
    implements ActionListener {
        DebugWindowButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            DebugWindow.this.clear();
        }
    }

    class DebugWindowListener
    extends WindowAdapter {
        DebugWindowListener() {
        }

        public void windowClosing(WindowEvent evt) {
            DebugWindow.this.clear();
        }

        public void windowClosed(WindowEvent evt) {
            DebugWindow.this.clear();
        }
    }
}

