/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import java.io.PrintStream;
import java.util.Date;

public class DebugPrintStream
extends PrintStream {
    String strLastClass = "";
    String strLastMethod = "";
    int lastLine = 0;
    boolean flagDate = true;
    boolean flagFullClassName = false;

    public DebugPrintStream() {
        super(System.out);
    }

    public DebugPrintStream(boolean newFlagDate) {
        super(System.out);
        this.flagDate = newFlagDate;
    }

    public DebugPrintStream(boolean newFlagDate, boolean newFlagFullClassName) {
        super(System.out);
        this.flagDate = newFlagDate;
        this.flagFullClassName = newFlagFullClassName;
    }

    public void print() {
    }

    public void print(boolean x) {
        this.printHeader();
        super.print(x);
    }

    public void print(char x) {
        this.printHeader();
        super.print(x);
    }

    public void print(int x) {
        this.printHeader();
        super.print(x);
    }

    public void print(long x) {
        this.printHeader();
        super.print(x);
    }

    public void print(float x) {
        this.printHeader();
        super.print(x);
    }

    public void print(double x) {
        this.printHeader();
        super.print(x);
    }

    public void print(char[] chArr) {
        this.printHeader();
        super.print(chArr);
    }

    public void print(String str) {
        this.printHeader();
        super.print(str);
    }

    public void print(Object obj) {
        this.printHeader();
        super.print(obj);
    }

    public void println() {
    }

    public void println(boolean x) {
        this.printHeader();
        super.print(String.valueOf(x) + "\n");
    }

    public void println(char x) {
        this.printHeader();
        super.print(String.valueOf(x) + "\n");
    }

    public void println(int x) {
        this.printHeader();
        super.print(String.valueOf(x) + "\n");
    }

    public void println(long x) {
        this.printHeader();
        super.print(String.valueOf(x) + "\n");
    }

    public void println(float x) {
        this.printHeader();
        super.print(String.valueOf(x) + "\n");
    }

    public void println(double x) {
        this.printHeader();
        super.print(String.valueOf(x) + "\n");
    }

    public void println(char[] chArr) {
        this.printHeader();
        super.print(String.valueOf(chArr.toString()) + "\n");
    }

    public void println(String str) {
        this.printHeader();
        super.print(String.valueOf(str) + "\n");
    }

    public void println(Object obj) {
        this.printHeader();
        super.print(obj + "\n");
    }

    private void printHeader() {
        StackTraceElement debugInfo = DebugPrintStream.getCallingClassAndMethod();
        String strCallingClass = debugInfo.getClassName();
        String strCallingMethod = debugInfo.getMethodName();
        String strFileName = debugInfo.getFileName();
        String strLineNumber = "" + debugInfo.getLineNumber();
        boolean flagPrintHeader = true;
        if (this.strLastClass.equals(strCallingClass) && this.strLastMethod.equals(strCallingMethod)) {
            flagPrintHeader = false;
        }
        if (flagPrintHeader) {
            StringBuffer strbuf = new StringBuffer();
            if (this.flagDate) {
                strbuf.append("\n>>> ");
                strbuf.append(new Date().toString());
            }
            strbuf.append("\n>>> ");
            if (this.flagFullClassName) {
                strbuf.append(strCallingClass);
            } else {
                int index = strCallingClass.lastIndexOf(".");
                strbuf.append(strCallingClass.substring(index + 1));
            }
            strbuf.append(".");
            strbuf.append(strCallingMethod);
            strbuf.append("(");
            strbuf.append(strFileName);
            strbuf.append(":");
            strbuf.append(strLineNumber);
            strbuf.append(")\n");
            super.print(strbuf.toString());
        }
        this.strLastClass = strCallingClass;
        this.strLastMethod = strCallingMethod;
        this.lastLine = debugInfo.getLineNumber();
    }

    public static StackTraceElement getCallingClassAndMethod() {
        return DebugPrintStream.getStackTrace()[4];
    }

    private static final StackTraceElement[] getStackTrace() {
        Throwable t = new Throwable().fillInStackTrace();
        return t.getStackTrace();
    }

    public static void test() {
        System.out.println("hey again");
        System.out.println("hey again2");
    }

    public static void main(String[] argv) {
        System.setOut(new DebugPrintStream());
        System.out.print("print");
        System.out.println("hi there");
        System.out.println("hi there2");
        System.out.println(true);
        System.out.println(5);
        DebugPrintStream.test();
        System.out.println("yo there");
        System.out.println("yo there2");
        System.out.println("yo there3");
    }
}

