/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.debugging.DebugWindow;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.event.TextEvent;

public class DebugEventQueue
extends EventQueue {
    private static DebugWindow debugWnd;

    public static final void installDebugEventQueue() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue q = tk.getSystemEventQueue();
        debugWnd = Debug.getDebugWindow();
        q.push(new DebugEventQueue());
    }

    private DebugEventQueue() {
    }

    private boolean isDebugWindowChild(Container cont, Component comp) {
        Component[] components = cont.getComponents();
        int i = 0;
        while (i < components.length) {
            boolean flag;
            if (components[i] == comp) {
                return true;
            }
            if (components[i] instanceof Container && (flag = this.isDebugWindowChild((Container)components[i], comp))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDebugWindowChild(Object obj) {
        if (debugWnd != null && obj instanceof Component) {
            return this.isDebugWindowChild(debugWnd, (Component)obj);
        }
        return false;
    }

    public void postEvent(AWTEvent evt) {
        if (!(evt instanceof TextEvent || evt instanceof PaintEvent || evt.getSource() == debugWnd || this.isDebugWindowChild(evt.getSource()))) {
            Debug.println(evt);
        }
        super.postEvent(evt);
    }
}

