/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.DebugWindow;
import edu.berkeley.guir.lib.debugging.LogFile;
import edu.berkeley.guir.lib.debugging.introspect.Introspect;
import edu.berkeley.guir.lib.debugging.introspect.JTreeIntrospectHandler;
import edu.berkeley.guir.lib.debugging.introspect.PrintIntrospectHandler;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Polygon;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Debug {
    private static final String LOGERR_PROPNAME = "guir.debug.logerr";
    private static final String WINDOW_PROPNAME = "guir.debug.window";
    private static final String OUTPUT_PROPNAME = "guir.debug.output";
    public static boolean LOGERR = Boolean.getBoolean("guir.debug.logerr");
    public static boolean WINDOW = Boolean.getBoolean("guir.debug.window");
    public static boolean OUTPUT = Boolean.getBoolean("guir.debug.output");
    public static boolean ENABLE_DEBUG = LOGERR || WINDOW || OUTPUT;
    public static boolean ON = true;
    public static boolean OFF = false;
    static boolean flagUseShortClassNames = true;
    static boolean flagMode = true;
    static PrintWriter pwriter;
    static DebugWindow debugWnd;
    static LogFile logFile;
    static String strLastHeader;
    static String strClassName;
    static String strMethodName;
    static StackTraceElement[] stack;
    static Map mapDebugIgnore;
    static /* synthetic */ Class class$0;

    static {
        if (ENABLE_DEBUG) {
            if (OUTPUT) {
                pwriter = new PrintWriter(System.out, true);
            }
            if (WINDOW) {
                debugWnd = new DebugWindow();
            }
            if (LOGERR) {
                try {
                    logFile = new LogFile("logfile.txt");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        strLastHeader = "";
        strClassName = "";
        strMethodName = "";
        mapDebugIgnore = new HashMap();
    }

    public Debug() {
    }

    public Debug(boolean flag) {
    }

    public static final void addDebugIgnore(Class cl) {
        Debug.addDebugIgnore(cl.getName());
    }

    public static final void removeDebugIgnore(Class cl) {
        Debug.removeDebugIgnore(cl.getName());
    }

    public static final boolean getDebugIgnore(Class cl) {
        return Debug.getDebugIgnore(cl.getName());
    }

    public static final void addDebugIgnore(String strClassName) {
        mapDebugIgnore.put(strClassName, Boolean.TRUE);
    }

    public static final void removeDebugIgnore(String strClassName) {
        mapDebugIgnore.remove(strClassName);
    }

    public static final boolean getDebugIgnore(String strClassName) {
        return mapDebugIgnore.containsKey(strClassName);
    }

    public static final void addDebugIgnore(Class cl, Method method) {
        Debug.addDebugIgnore(cl.getName(), method.getName());
    }

    public static final void removeDebugIgnore(Class cl, Method method) {
        Debug.removeDebugIgnore(cl.getName(), method.getName());
    }

    public static final boolean getDebugIgnore(Class cl, Method method) {
        return Debug.getDebugIgnore(cl.getName(), method.getName());
    }

    public static final void addDebugIgnore(Class cl, String strMethodName) {
        Debug.addDebugIgnore(cl.getName(), strMethodName);
    }

    public static final void removeDebugIgnore(Class cl, String strMethodName) {
        Debug.removeDebugIgnore(cl.getName(), strMethodName);
    }

    public static final boolean getDebugIgnore(Class cl, String strMethodName) {
        return Debug.getDebugIgnore(cl.getName(), strMethodName);
    }

    public static final void addDebugIgnore(String strClassName, String strMethodName) {
        mapDebugIgnore.put(String.valueOf(strClassName) + ":" + strMethodName, Boolean.TRUE);
    }

    public static final void removeDebugIgnore(String strClassName, String strMethodName) {
        mapDebugIgnore.remove(String.valueOf(strClassName) + ":" + strMethodName);
    }

    public static final boolean getDebugIgnore(String strClassName, String strMethodName) {
        if (Debug.getDebugIgnore(strClassName)) {
            return true;
        }
        return mapDebugIgnore.containsKey(String.valueOf(strClassName) + ":" + strMethodName);
    }

    public static final Iterator getAllDebugIgnore() {
        return mapDebugIgnore.keySet().iterator();
    }

    public static final void printAllDebugIgnore() {
        Iterator it = mapDebugIgnore.keySet().iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public static String[] getCurrentClassAndMethod() {
        return Debug.getCallerInfo(Debug.getStackTrace(), 2);
    }

    public static String[] getCallingClassAndMethod() {
        return Debug.getCallerInfo(Debug.getStackTrace(), 3);
    }

    public static void setDebugMode(boolean flag) {
        flagMode = flag;
    }

    public static final boolean getDebugMode() {
        if (!ENABLE_DEBUG) {
            return false;
        }
        if (!flagMode) {
            return false;
        }
        String[] str = Debug.getCallerInfo(Debug.getStackTrace(), 3);
        strClassName = str[1];
        strMethodName = str[2];
        return ENABLE_DEBUG && flagMode && !Debug.getDebugIgnore(strClassName, strMethodName);
    }

    public static void setUseShortClassNames(boolean flag) {
        flagUseShortClassNames = flag;
    }

    public static void setUseWindow(boolean flag) {
        WINDOW = flag;
        if (flag) {
            debugWnd = new DebugWindow();
        }
        ENABLE_DEBUG = LOGERR || WINDOW || OUTPUT;
    }

    public static final DebugWindow getDebugWindow() {
        return debugWnd;
    }

    public static void getNewDebugWindow(boolean flag) {
        WINDOW = flag;
        if (flag) {
            debugWnd = new DebugWindow();
        }
        ENABLE_DEBUG = LOGERR || WINDOW || OUTPUT;
    }

    public static void printStackTrace() {
        if (Debug.getDebugMode()) {
            Debug.println(new RuntimeException("Printing Stack Trace"));
        }
    }

    public static void printStackTrace(StackTraceElement[] stack) {
        if (Debug.getDebugMode()) {
            int i = 0;
            while (i < stack.length) {
                Debug.println(String.valueOf(stack[i].getClassName()) + ":" + stack[i].getMethodName() + ":" + stack[i].getLineNumber());
                ++i;
            }
        }
    }

    private static boolean isPrimitive(Class cl) {
        block8: {
            block7: {
                if (cl.isPrimitive()) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (cl != clazz) break block8;
            }
            return true;
        }
        return false;
    }

    private static boolean shouldPrint(Field f) {
        int val = f.getModifiers();
        return !Modifier.isFinal(val) || !Modifier.isStatic(val);
    }

    public static String toString(Object obj) {
        StringBuffer strbuf = new StringBuffer();
        Class<?> cl = obj.getClass();
        try {
            if (!Debug.isPrimitive(cl)) {
                List listFields = Debug.getAllFields(cl);
                Field[] fields = new Field[listFields.size()];
                listFields.toArray(fields);
                int i = 0;
                while (i < fields.length) {
                    if (Debug.shouldPrint(fields[i])) {
                        strbuf.append(String.valueOf(fields[i].getName()) + " = " + fields[i].get(obj) + "\n");
                    }
                    ++i;
                }
            } else {
                strbuf.append(obj.toString());
            }
        }
        catch (Exception e) {
            strbuf.append(e);
        }
        return strbuf.toString();
    }

    private static List getAllFields(Class cl) {
        return Debug.getAllFields(cl, new LinkedList());
    }

    private static List getAllFields(Class cl, List l) {
        Field[] fields = cl.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            l.add(fields[i]);
            ++i;
        }
        Class parent = cl.getSuperclass();
        if (parent != null && !parent.isInterface() && !parent.isPrimitive()) {
            Debug.getAllFields(parent, l);
        }
        return l;
    }

    public static void displayObjectTree(Object obj) {
        if (Debug.getDebugMode()) {
            JTreeIntrospectHandler h = new JTreeIntrospectHandler();
            Introspect.parseObject(obj, h);
            h.displayJTree();
        }
    }

    public static void displayObjectStream(Object obj, OutputStream out) {
        if (Debug.getDebugMode()) {
            Introspect.parseObject(obj, new PrintIntrospectHandler(out));
        }
    }

    public static void displayObjectStream(Object obj, PrintWriter out) {
        if (Debug.getDebugMode()) {
            Introspect.parseObject(obj, new PrintIntrospectHandler(out));
        }
    }

    public static void displayObjectStream(Object obj) {
        if (Debug.getDebugMode()) {
            Introspect.parseObject(obj, new PrintIntrospectHandler(System.out));
        }
    }

    private static String getHeader() {
        return ">>> " + strClassName + ":" + strMethodName + "() <<<";
    }

    public static final void println() {
        if (Debug.getDebugMode()) {
            if (OUTPUT) {
                pwriter.println();
            }
            if (WINDOW) {
                debugWnd.println();
            }
        }
    }

    public static void println(String str) {
        if (Debug.getDebugMode()) {
            String strOut;
            String strHeader = Debug.getHeader();
            if (strLastHeader.hashCode() == strHeader.hashCode()) {
                strHeader = "";
                if (LOGERR) {
                    logFile.setPrintTime(false);
                }
            } else {
                strLastHeader = strHeader;
                strHeader = String.valueOf(strHeader) + "\n";
                if (LOGERR) {
                    logFile.setPrintTime(true);
                }
            }
            if (WINDOW) {
                String strWin = StringLib.fold("   ", str, Integer.MAX_VALUE);
                debugWnd.println(String.valueOf(strHeader) + strWin);
            }
            if (OUTPUT) {
                strOut = StringLib.fold("   ", str, Integer.MAX_VALUE);
                pwriter.println(String.valueOf(strHeader) + strOut);
            }
            if (LOGERR) {
                strOut = StringLib.fold("   ", str, Integer.MAX_VALUE);
                logFile.logMessage(String.valueOf(strHeader) + strOut);
            }
        }
    }

    public static final void println(Throwable e) {
        if (Debug.getDebugMode()) {
            if (OUTPUT) {
                e.printStackTrace(pwriter);
            }
            if (WINDOW || LOGERR) {
                StringWriter swriter = new StringWriter();
                PrintWriter pwriter = new PrintWriter(swriter);
                e.printStackTrace(pwriter);
                pwriter.flush();
                if (WINDOW) {
                    debugWnd.println(swriter.toString());
                }
                if (LOGERR) {
                    logFile.setPrintTime(true);
                    logFile.logMessage(swriter.toString());
                }
            }
        }
    }

    public static final void println(Object obj) {
        if (Debug.getDebugMode()) {
            if (obj == null) {
                Debug.println("null");
            } else {
                Debug.println(obj.toString());
            }
        }
    }

    public static final void println(Object[] objArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(objArray));
        }
    }

    public static final void println(boolean flag) {
        if (Debug.getDebugMode()) {
            if (flag) {
                Debug.println("true");
            } else {
                Debug.println("false");
            }
        }
    }

    public static final void println(byte b) {
        if (Debug.getDebugMode()) {
            Debug.println(Byte.toString(b));
        }
    }

    public static final void println(byte[] bArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(bArray));
        }
    }

    public static final void println(short s) {
        if (Debug.getDebugMode()) {
            Debug.println(Short.toString(s));
        }
    }

    public static final void println(short[] sArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(sArray));
        }
    }

    public static final void println(char ch) {
        if (Debug.getDebugMode()) {
            Debug.println("" + ch);
        }
    }

    public static final void println(char[] chArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(chArray));
        }
    }

    public static final void println(double d) {
        if (Debug.getDebugMode()) {
            Debug.println(Double.toString(d));
        }
    }

    public static final void println(double[] dArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(dArray));
        }
    }

    public static final void println(float f) {
        if (Debug.getDebugMode()) {
            Debug.println(Float.toString(f));
        }
    }

    public static final void println(float[] fArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(fArray));
        }
    }

    public static final void println(int i) {
        if (Debug.getDebugMode()) {
            Debug.println(Integer.toString(i));
        }
    }

    public static final void println(int[] intArray) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(intArray));
        }
    }

    public static final void println(Polygon poly) {
        if (Debug.getDebugMode()) {
            Debug.println(StringLib.toString(poly));
        }
    }

    private static final String fixClassName(String strClassName) {
        if (flagUseShortClassNames) {
            int index = strClassName.lastIndexOf(46);
            return strClassName.substring(index + 1);
        }
        return strClassName;
    }

    private static final StackTraceElement[] getStackTrace() {
        Throwable t = new Throwable().fillInStackTrace();
        return t.getStackTrace();
    }

    private static final void storeStackTrace() {
        Throwable t = new Throwable().fillInStackTrace();
        stack = t.getStackTrace();
    }

    private static String[] getCallerInfo(StackTraceElement[] stack, int back) {
        String[] strClassMethod = new String[]{stack[back].getFileName(), Debug.fixClassName(stack[back].getClassName()), stack[back].getMethodName()};
        return strClassMethod;
    }

    public static void main(String[] argv) {
        Debug.displayObjectStream("hi there");
        Debug.displayObjectStream(new Integer(4));
        Debug.displayObjectStream(new Polygon2D());
    }
}

