/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple.filter;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.collection.tuple.filter.TupleFilterBaseImpl;
import edu.berkeley.guir.lib.util.filter.Filter;

public class TupleFilterByXPath
extends TupleFilterBaseImpl {
    String strXPath;
    String strPattern;

    public TupleFilterByXPath(String newXPath) {
        this.strXPath = newXPath;
        this.strPattern = null;
    }

    public TupleFilterByXPath(String newXPath, String newPattern) {
        this.strXPath = newXPath;
        this.strPattern = newPattern;
    }

    public String getXPath() {
        return this.strXPath;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public boolean isAccepted(Object obj) {
        try {
            Tuple t = (Tuple)obj;
            String strVal = t.getXPath(this.strXPath);
            if (strVal == null) {
                return false;
            }
            if (this.strPattern == null) {
                return true;
            }
            return strVal.matches(this.strPattern);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("TupleFilterByXPath: [xpath: ");
        strbuf.append(this.getXPath());
        strbuf.append(", pattern: ");
        strbuf.append(this.getPattern());
        strbuf.append("]");
        return strbuf.toString();
    }

    public static void testAAA(Filter f, Tuple t) {
        System.out.println("------------------");
        System.out.println(f);
        System.out.println(t);
        System.out.println("accept: " + f.isAccepted(t));
    }

    public static void main(String[] argv) {
        TupleFilterByXPath f = new TupleFilterByXPath("/ContextTuple/@dataformat");
        TupleFilterByXPath.testAAA(f, Tuple.getTestInstanceAAA());
        TupleFilterByXPath.testAAA(f, Tuple.getTestInstanceBBB());
        TupleFilterByXPath.testAAA(f, Tuple.getTestInstanceCCC());
        f = new TupleFilterByXPath("/ContextTuple/@entity-type", "person");
        TupleFilterByXPath.testAAA(f, Tuple.getTestInstanceAAA());
        TupleFilterByXPath.testAAA(f, Tuple.getTestInstanceBBB());
        TupleFilterByXPath.testAAA(f, Tuple.getTestInstanceCCC());
    }
}

