/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple.filter;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.collection.tuple.filter.TupleFilterBaseImpl;
import edu.berkeley.guir.lib.util.filter.Filter;

public class TupleFilterByType
extends TupleFilterBaseImpl {
    String strTupleTypePattern;

    public TupleFilterByType(String newTupleTypePattern) {
        this.strTupleTypePattern = newTupleTypePattern;
    }

    public String getTupleTypePattern() {
        return this.strTupleTypePattern;
    }

    public boolean isAccepted(Object obj) {
        try {
            Tuple t = (Tuple)obj;
            String strVal = t.getTupleType();
            if (strVal == null) {
                return false;
            }
            return strVal.matches(this.strTupleTypePattern);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("TupleFilterByType: [pattern: ");
        strbuf.append(this.getTupleTypePattern());
        strbuf.append("]");
        return strbuf.toString();
    }

    public static void testAAA(Filter f, Tuple t) {
        System.out.println("------------------");
        System.out.println(f);
        System.out.println(t);
        System.out.println("accept: " + f.isAccepted(t));
    }

    public static void main(String[] argv) {
        TupleFilterByType f = new TupleFilterByType("ContextTuple");
        TupleFilterByType.testAAA(f, Tuple.getTestInstanceAAA());
        TupleFilterByType.testAAA(f, Tuple.getTestInstanceBBB());
        TupleFilterByType.testAAA(f, Tuple.getTestInstanceCCC());
        f = new TupleFilterByType("person");
        TupleFilterByType.testAAA(f, Tuple.getTestInstanceAAA());
        TupleFilterByType.testAAA(f, Tuple.getTestInstanceBBB());
        TupleFilterByType.testAAA(f, Tuple.getTestInstanceCCC());
    }
}

