/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple.filter;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.collection.tuple.filter.TupleFilterBaseImpl;
import edu.berkeley.guir.lib.util.filter.Filter;

public class TupleFilterByAttribute
extends TupleFilterBaseImpl {
    String strAttribute;
    String strPattern;

    public TupleFilterByAttribute(String newAttribute) {
        this.strAttribute = newAttribute;
        this.strPattern = null;
    }

    public TupleFilterByAttribute(String newAttribute, String newPattern) {
        this.strAttribute = newAttribute;
        this.strPattern = newPattern;
    }

    public String getAttribute() {
        return this.strAttribute;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public boolean isAccepted(Object obj) {
        try {
            Tuple t = (Tuple)obj;
            String strVal = t.getAttribute(this.strAttribute);
            if (strVal == null) {
                return false;
            }
            if (this.strPattern == null) {
                return true;
            }
            return strVal.matches(this.strPattern);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("TupleFilterByAttribute: [attr: ");
        strbuf.append(this.getAttribute());
        strbuf.append(", pattern: ");
        strbuf.append(this.getPattern());
        strbuf.append("]");
        return strbuf.toString();
    }

    public static void testAAA(Filter f, Tuple t) {
        System.out.println("------------------");
        System.out.println(f);
        System.out.println(t);
        System.out.println("accept: " + f.isAccepted(t));
    }

    public static void main(String[] argv) {
        TupleFilterByAttribute f = new TupleFilterByAttribute("dataformat");
        TupleFilterByAttribute.testAAA(f, Tuple.getTestInstanceAAA());
        TupleFilterByAttribute.testAAA(f, Tuple.getTestInstanceBBB());
        TupleFilterByAttribute.testAAA(f, Tuple.getTestInstanceCCC());
        f = new TupleFilterByAttribute("entity-type", "person");
        TupleFilterByAttribute.testAAA(f, Tuple.getTestInstanceAAA());
        TupleFilterByAttribute.testAAA(f, Tuple.getTestInstanceBBB());
        TupleFilterByAttribute.testAAA(f, Tuple.getTestInstanceCCC());
    }
}

