/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.util.comparator.DateComparator;
import edu.berkeley.guir.lib.util.comparator.DoubleComparator;
import edu.berkeley.guir.lib.util.comparator.IntegerComparator;
import edu.berkeley.guir.lib.util.comparator.StringComparator;
import java.util.Comparator;

public final class TupleTypes {
    public static final int TYPE_DATE = -1;
    public static final int TYPE_DOUBLE = -2;
    public static final int TYPE_INTEGER = -3;
    public static final int TYPE_STRING = -4;
    public static final Integer INT_TYPE_DATE = new Integer(-1);
    public static final Integer INT_TYPE_DOUBLE = new Integer(-2);
    public static final Integer INT_TYPE_INTEGER = new Integer(-3);
    public static final Integer INT_TYPE_STRING = new Integer(-4);
    private static final Comparator COMPARATOR_DATE = new DateComparator(Tuple.getDateFormat());
    private static final Comparator COMPARATOR_INT = new IntegerComparator();
    private static final Comparator COMPARATOR_DOUBLE = new DoubleComparator();
    private static final Comparator COMPARATOR_STRING = new StringComparator();

    public static Comparator getComparator(int sorttype) {
        switch (sorttype) {
            case -1: {
                return COMPARATOR_DATE;
            }
            case -2: {
                return COMPARATOR_DOUBLE;
            }
            case -3: {
                return COMPARATOR_INT;
            }
            case -4: {
                return COMPARATOR_STRING;
            }
        }
        return COMPARATOR_STRING;
    }
}

