/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.collection.tuple.TupleParser;
import edu.berkeley.guir.lib.collection.tuple.TupleParserException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TupleParserDefaultImpl
implements TupleParser {
    protected Tuple createNewTuple() {
        return new Tuple();
    }

    protected Tuple createNewTuple(String strElementName) {
        return new Tuple(strElementName);
    }

    public Tuple parse(String str) throws TupleParserException {
        return this.parse(new InputSource(new StringReader(str)));
    }

    public Tuple parse(InputStream istream) throws TupleParserException {
        Tuple t = this.parse(new InputSource(istream));
        try {
            istream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public Tuple parse(Reader rdr) throws TupleParserException {
        Tuple t = this.parse(new InputSource(rdr));
        try {
            rdr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public Tuple parse(InputSource isrc) throws TupleParserException {
        TupleHandler handler;
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            handler = new TupleHandler();
            parser.parse(isrc, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new TupleParserException(e);
        }
        return handler.getRoot();
    }

    private class TupleHandler
    extends DefaultHandler {
        Tuple rootTuple;
        Tuple currentTuple;
        List listTuples = new LinkedList();

        TupleHandler() {
        }

        public void push(Tuple t) {
            if (this.listTuples.size() <= 0) {
                this.rootTuple = t;
            }
            this.listTuples.add(t);
        }

        public void pop() {
            this.listTuples.remove(this.listTuples.size() - 1);
        }

        public Tuple poke() {
            if (this.listTuples.size() <= 0) {
                return null;
            }
            return (Tuple)this.listTuples.get(this.listTuples.size() - 1);
        }

        public Tuple getRoot() {
            return this.rootTuple;
        }

        public void startElement(String uri, String localName, String elementName, Attributes attr) throws SAXException {
            super.startElement(uri, localName, elementName, attr);
            this.currentTuple = TupleParserDefaultImpl.this.createNewTuple(elementName);
            int i = 0;
            while (i < attr.getLength()) {
                this.currentTuple.setAttribute(attr.getQName(i), attr.getValue(i));
                ++i;
            }
            Tuple t = this.poke();
            if (t != null) {
                t.addTuple(this.currentTuple);
            }
            this.push(this.currentTuple);
        }

        public void endElement(String uri, String localName, String elementName) throws SAXException {
            super.endElement(uri, localName, elementName);
            this.pop();
        }
    }
}

