/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple;

import edu.berkeley.guir.lib.collection.HashMapList;
import edu.berkeley.guir.lib.collection.tuple.Tuple;
import edu.berkeley.guir.lib.collection.tuple.TupleWrapper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TupleLib {
    private static final boolean DEBUG = false;
    public static final Tuple EMPTY = new EmptyTuple();

    public static Tuple listToTuple(String strListName, List listTuples) {
        Tuple t = new Tuple(strListName);
        t.setDynamicSize(true);
        t.addTuples(listTuples);
        return t;
    }

    public static List tupleToList(Tuple t) {
        return t.getTuples();
    }

    public static List extractAttribute(List listTuples, String strAttr) {
        Iterator it = listTuples.iterator();
        LinkedList<String> listAttributes = new LinkedList<String>();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            String strVal = t.getAttribute(strAttr);
            if (strVal == null) continue;
            listAttributes.add(strVal);
        }
        return listAttributes;
    }

    public static List extractXPath(List listTuples, String strXPath) {
        Iterator it = listTuples.iterator();
        LinkedList<String> listXPaths = new LinkedList<String>();
        while (it.hasNext()) {
            try {
                Tuple t = (Tuple)it.next();
                String strVal = t.getXPath(strXPath);
                if (strVal == null) continue;
                listXPaths.add(strVal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listXPaths;
    }

    public static List unique(List listTuples, String strAttribute) {
        HashSet<String> setVals = new HashSet<String>();
        Iterator it = listTuples.iterator();
        LinkedList<Tuple> listOut = new LinkedList<Tuple>();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            String strVal = t.getAttribute(strAttribute);
            if (setVals.contains(strVal)) continue;
            listOut.add(t);
            setVals.add(strVal);
        }
        return listOut;
    }

    public static HashMapList index(List listTuples, String strXPath) {
        HashMapList map = new HashMapList();
        Iterator it = listTuples.iterator();
        while (it.hasNext()) {
            try {
                Tuple t = (Tuple)it.next();
                String strXPathVal = t.getXPath(strXPath);
                map.put(strXPathVal, t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    private static List getTestInstanceAAA() {
        LinkedList<Tuple> listTuples = new LinkedList<Tuple>();
        Tuple t = new Tuple("Location");
        t.setAttribute("CityName", "Berkeley");
        t.setAttribute("ZIPCode", "94709");
        listTuples.add(t);
        t = new Tuple("Location");
        t.setAttribute("CityName", "Kensington");
        t.setAttribute("ZIPCode", "94707");
        listTuples.add(t);
        t = new Tuple("Location");
        t.setAttribute("CityName", "Berkeley");
        t.setAttribute("ZIPCode", "94703");
        listTuples.add(t);
        return listTuples;
    }

    public static void main(String[] argv) throws Exception {
        System.out.println(TupleLib.getTestInstanceAAA());
        System.out.println();
        System.out.println(TupleLib.unique(TupleLib.getTestInstanceAAA(), "CityName"));
        System.out.println();
        System.out.println(TupleLib.unique(TupleLib.getTestInstanceAAA(), "ZIPCode"));
        System.out.println();
    }

    public static class ImmutableTupleWrapper
    extends TupleWrapper {
        public ImmutableTupleWrapper(Tuple t) {
            super(t);
        }

        private void unsupported() {
            throw new UnsupportedOperationException("Immutable");
        }

        public void setTupleType(String str) {
            this.unsupported();
        }

        public void setDynamicSize(boolean flag) {
            this.unsupported();
        }

        public void setAttributes(Map map) {
            this.unsupported();
        }

        public void setAttribute(String strKey, String strVal) {
            this.unsupported();
        }

        public void clearAttributes() {
            this.unsupported();
        }

        public void setTo(Tuple t) {
            this.unsupported();
        }

        public void addTuples(List list) {
            this.unsupported();
        }

        public void addTuple(Tuple tuple) {
            this.unsupported();
        }

        public void clearTuples() {
            this.unsupported();
        }

        public void removeTuple(Tuple t) {
            this.unsupported();
        }
    }

    public static final class EmptyTuple
    extends Tuple {
        public EmptyTuple() {
            super("empty");
        }

        public void setTupleType(String str) {
            super.setTupleType("empty");
        }

        public void setDynamicSize(boolean flag) {
        }

        public void setAttributes(Map map) {
        }

        public void setAttribute(String strKey, String strVal) {
        }

        public void clearAttributes() {
        }

        public void addTuples(List list) {
        }

        public void addTuple(Tuple tuple) {
        }

        public void clearTuples() {
        }

        public void removeTuple(Tuple t) {
        }
    }
}

