/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tuple;

import edu.berkeley.guir.lib.collection.tuple.TupleLib;
import edu.berkeley.guir.lib.collection.tuple.TupleParser;
import edu.berkeley.guir.lib.collection.tuple.TupleParserDefaultImpl;
import edu.berkeley.guir.lib.collection.tuple.TupleParserException;
import edu.berkeley.guir.lib.collection.tuple.TupleXPathHandler;
import edu.berkeley.guir.lib.collection.tuple.comparator.TupleComparator;
import edu.berkeley.guir.lib.collection.tuple.filter.TupleFilter;
import edu.berkeley.guir.lib.collection.tuple.filter.TupleFilterByAttribute;
import edu.berkeley.guir.lib.collection.tuple.filter.TupleFilterByType;
import edu.berkeley.guir.lib.util.StringLib;
import edu.berkeley.guir.lib.web.HtmlCodec;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Tuple {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    public static final String KEY_SIZE = "size";
    public static final int INDENT = 3;
    private static TupleParser PARSER = new TupleParserDefaultImpl();
    public static Tuple EMPTY = TupleLib.EMPTY;
    public static final DateFormat DEFAULT_DATEFORMAT;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    static DateFormat dformat;
    static TupleXPathHandler xpathHandler;
    String strTupleType = "undefined";
    Map mapAttributes = null;
    List listTuples = null;
    boolean flagDynamicSize = false;

    static {
        dformat = DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy.MMM.dd HH:mm:ss z");
        xpathHandler = TupleXPathHandler.EMPTY;
    }

    public static void setTupleParser(TupleParser newTupleParser) {
        PARSER = newTupleParser;
    }

    public static Tuple parse(String str) throws TupleParserException {
        return PARSER.parse(str);
    }

    public static Tuple parse(InputStream istream) throws TupleParserException {
        return PARSER.parse(istream);
    }

    public static Tuple parse(Reader rdr) throws TupleParserException {
        return PARSER.parse(rdr);
    }

    public static void setDateFormat(DateFormat newDateFormat) {
        dformat = newDateFormat;
    }

    public static DateFormat getDateFormat() {
        return dformat;
    }

    public static void setXPathHandler(TupleXPathHandler xph) {
        xpathHandler = xph;
    }

    public static TupleXPathHandler getXPathHandler() {
        return xpathHandler;
    }

    public static String xmlEncode(String str) {
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        return str;
    }

    public Tuple() {
    }

    public Tuple(String strTupleType) {
        this.setTupleType(strTupleType);
    }

    public Tuple(String strTupleType, Map mapAttributes) {
        this.setTupleType(strTupleType);
        this.setAttributes(mapAttributes);
    }

    public Tuple(String strTupleType, Map mapAttributes, List listTuples) {
        this.setTupleType(strTupleType);
        this.setAttributes(mapAttributes);
        this.addTuples(listTuples);
    }

    public Tuple(File f) throws IOException, TupleParserException {
        FileReader rdr = new FileReader(f);
        Tuple t = PARSER.parse(rdr);
        this.setTo(t);
    }

    public Tuple(Reader rdr) throws TupleParserException {
        Tuple t = PARSER.parse(rdr);
        this.setTo(t);
    }

    public Tuple(Tuple t) {
        this.setTupleType(t.getTupleType());
        this.setAttributes(t.getAttributes());
        Iterator it = t.tuples();
        while (it.hasNext()) {
            Tuple tTmp = (Tuple)it.next();
            this.addTuple(new Tuple(tTmp));
        }
    }

    public Tuple(Map m) {
        this.setAttributes(m);
    }

    public Tuple(Element elem) {
        Node n;
        this.setTupleType(elem.getNodeName());
        NamedNodeMap map = elem.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            n = map.item(i);
            this.setAttribute(n.getNodeName(), n.getNodeValue());
            ++i;
        }
        NodeList list = elem.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            n = list.item(i2);
            if (n instanceof Element) {
                this.addTuple(new Tuple((Element)n));
            }
            ++i2;
        }
    }

    private void initAttributes() {
        if (this.mapAttributes == null) {
            this.mapAttributes = new LinkedHashMap();
        }
    }

    private void initTuples() {
        if (this.listTuples == null) {
            this.listTuples = new LinkedList();
        }
    }

    public void setTupleType(String newTupleType) {
        if (newTupleType == null) {
            throw new IllegalArgumentException("Tuple type cannot be null");
        }
        this.strTupleType = newTupleType;
    }

    public String getTupleType() {
        return this.strTupleType;
    }

    public boolean isTupleType(String strTupleType) {
        return this.getTupleType().equals(strTupleType);
    }

    private void updateSize() {
        if (this.flagDynamicSize) {
            this.setAttribute(KEY_SIZE, "" + this.getNumTuples());
        }
    }

    public void setDynamicSize(boolean flag) {
        this.flagDynamicSize = flag;
    }

    public boolean hasDynamicSize() {
        return this.flagDynamicSize;
    }

    public void setAttributes(Map map) {
        Iterator it = map.keySet().iterator();
        this.initAttributes();
        while (it.hasNext()) {
            String strKey = (String)it.next();
            String strVal = (String)map.get(strKey);
            if (strKey == null || strVal == null) continue;
            this.mapAttributes.put(strKey, strVal);
        }
    }

    public void setAttribute(String strKey, String strVal) {
        this.initAttributes();
        if (strVal == null) {
            this.mapAttributes.remove(strKey);
        } else {
            this.mapAttributes.put(strKey, Tuple.xmlEncode(strVal));
        }
    }

    public void setAttribute(String strKey, boolean flag) {
        String str = TRUE;
        if (!flag) {
            str = FALSE;
        }
        this.setAttribute(strKey, str);
    }

    public void setAttribute(String strKey, int val) {
        this.setAttribute(strKey, "" + val);
    }

    public void setAttribute(String strKey, long val) {
        this.setAttribute(strKey, "" + val);
    }

    public void setAttribute(String strKey, double val) {
        this.setAttribute(strKey, "" + val);
    }

    public String getAttribute(String strKey) {
        if (this.mapAttributes == null) {
            return null;
        }
        if (KEY_SIZE.equals(strKey)) {
            this.updateSize();
        }
        String str = (String)this.mapAttributes.get(strKey);
        return HtmlCodec.decode(str);
    }

    public boolean getAttributeAsBoolean(String strKey) {
        String str = this.getAttribute(strKey);
        return TRUE.equalsIgnoreCase(str);
    }

    public int getAttributeAsInt(String strKey) {
        return Integer.parseInt(this.getAttribute(strKey));
    }

    public long getAttributeAsLong(String strKey) {
        return Long.parseLong(this.getAttribute(strKey));
    }

    public double getAttributeAsDouble(String strKey) {
        return Double.parseDouble(this.getAttribute(strKey));
    }

    public void clearAttributes() {
        this.mapAttributes = null;
    }

    public Iterator attributeKeys() {
        if (this.mapAttributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.mapAttributes.keySet().iterator();
    }

    public Map getAttributes() {
        this.updateSize();
        if (this.mapAttributes == null) {
            return Collections.EMPTY_MAP;
        }
        return new LinkedHashMap(this.mapAttributes);
    }

    public int getNumAttributes() {
        this.updateSize();
        if (this.mapAttributes == null) {
            return 0;
        }
        return this.mapAttributes.size();
    }

    public void setTo(Tuple t) {
        this.strTupleType = t.strTupleType;
        this.mapAttributes = t.mapAttributes;
        this.listTuples = t.listTuples;
        this.flagDynamicSize = t.flagDynamicSize;
    }

    public void sortTuples(TupleComparator c) {
        Collections.sort(this.listTuples, c);
    }

    public void addTuples(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.addTuple((Tuple)it.next());
        }
    }

    public void addTuple(Tuple tuple) {
        this.initTuples();
        this.listTuples.add(tuple);
    }

    public Iterator tuples() {
        if (this.listTuples == null) {
            return EMPTY_ITERATOR;
        }
        return this.listTuples.iterator();
    }

    public Iterator tuples(TupleComparator c) {
        List listTuples = this.getTuples(c);
        return listTuples.iterator();
    }

    public void clearTuples() {
        this.listTuples = null;
    }

    public void removeTuple(Tuple t) {
        if (this.listTuples != null) {
            this.listTuples.remove(t);
        }
    }

    public void removeTuplesByType(String strTupleType) {
        this.initTuples();
        List listRemoveTuples = this.getTuplesByType(strTupleType);
        this.listTuples.removeAll(listRemoveTuples);
    }

    public void removeTuplesByAttribute(String strAttribute) {
        this.initTuples();
        List listRemoveTuples = this.getTuplesByAttribute(strAttribute);
        this.listTuples.removeAll(listRemoveTuples);
    }

    public void removeTuplesByAttribute(String strAttribute, String strPattern) {
        this.initTuples();
        List listRemoveTuples = this.getTuplesByAttribute(strAttribute, strPattern);
        this.listTuples.removeAll(listRemoveTuples);
    }

    public Tuple getTuple(int i) {
        this.initTuples();
        return (Tuple)this.listTuples.get(i);
    }

    public Tuple getFirstTuple() {
        if (this.listTuples == null) {
            return null;
        }
        return (Tuple)this.listTuples.get(0);
    }

    public Tuple getLastTuple() {
        if (this.listTuples == null) {
            return null;
        }
        return (Tuple)this.listTuples.get(this.listTuples.size() - 1);
    }

    public List getTuples() {
        if (this.listTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return new LinkedList(this.listTuples);
    }

    public List getTuples(TupleComparator c) {
        if (this.listTuples == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList list = new LinkedList(this.listTuples);
        Collections.sort(list, c);
        return list;
    }

    public List getTuples(TupleFilter f) {
        if (this.listTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return f.keepAccepted(this.listTuples);
    }

    public Tuple getTupleByType(String strTupleType) {
        Iterator it = this.tuples();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            if (!strTupleType.equals(t.getTupleType())) continue;
            return t;
        }
        return null;
    }

    public List getTuplesByType(String strTupleType) {
        return this.getTuples(new TupleFilterByType(strTupleType));
    }

    public Tuple getTupleByAttribute(String strAttribute) {
        Iterator it = this.tuples();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            if (t.getAttribute(strAttribute) == null) continue;
            return t;
        }
        return null;
    }

    public List getTuplesByAttribute(String strAttribute) {
        return this.getTuples(new TupleFilterByAttribute(strAttribute));
    }

    public Tuple getTupleByAttribute(String strAttribute, String strPattern) {
        Iterator it = this.tuples();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            String attr = t.getAttribute(strAttribute);
            if (attr == null || !attr.matches(strPattern)) continue;
            return t;
        }
        return null;
    }

    public List getTuplesByAttribute(String strAttribute, String strPattern) {
        return this.getTuples(new TupleFilterByAttribute(strAttribute, strPattern));
    }

    public void sortTuples(Comparator c) {
        Collections.sort(this.listTuples, c);
    }

    public int getNumTuples() {
        if (this.listTuples == null) {
            return 0;
        }
        return this.listTuples.size();
    }

    public String getXPath(String strXPath) throws Exception {
        return Tuple.getXPathHandler().getXPath(this, strXPath);
    }

    public int hashCode() {
        return this.getHashKey().hashCode();
    }

    private String getMapHashCode() {
        if (this.mapAttributes == null) {
            return "null";
        }
        return "" + this.mapAttributes.hashCode();
    }

    private String getListHashCode() {
        if (this.listTuples == null) {
            return "null";
        }
        return "" + this.listTuples.hashCode();
    }

    public String getHashKey() {
        return this.strTupleType + this.getMapHashCode() + this.getListHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple tAA = this;
        Tuple tBB = (Tuple)obj;
        if (tAA == tBB) {
            return true;
        }
        return tAA.getHashKey().equals(tBB.getHashKey());
    }

    public List getKeyOrder() {
        if (this.getNumAttributes() <= 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList listKeys = new LinkedList(this.mapAttributes.keySet());
        Collections.sort(listKeys);
        return listKeys;
    }

    protected String mapToSingleLine(Map map) {
        Iterator it = this.getKeyOrder().iterator();
        StringBuffer strbuf = new StringBuffer();
        while (it.hasNext()) {
            String strKey = (String)it.next();
            String strVal = (String)map.get(strKey);
            strbuf.append(strKey);
            strbuf.append("=\"");
            strbuf.append(strVal);
            strbuf.append("\" ");
        }
        return strbuf.toString();
    }

    protected void handleStartTag(StringBuffer strbuf, int indent, boolean flagMulti) {
        String strBalancedMap;
        if (this.getNumAttributes() <= 0 && this.getNumTuples() <= 0) {
            strbuf.append(StringLib.blank(indent));
            strbuf.append("<");
            strbuf.append(this.getTupleType());
            strbuf.append("/>");
            return;
        }
        if (this.getNumAttributes() <= 0 && this.getNumTuples() > 0) {
            strbuf.append(StringLib.blank(indent));
            strbuf.append("<");
            strbuf.append(this.getTupleType());
            strbuf.append(">");
            return;
        }
        if (flagMulti) {
            strBalancedMap = StringLib.alignRight(this.mapAttributes, this.getKeyOrder(), "=\"", "\"");
            int shiftRight = this.getTupleType().length() + 1;
            int shiftLeft = 0;
            int len = strBalancedMap.length();
            int i = 0;
            while (i < len) {
                if (strBalancedMap.charAt(i) != ' ') break;
                ++shiftLeft;
                ++i;
            }
            int oldShiftRight = shiftRight + indent;
            shiftRight = Math.max(2, shiftRight - shiftLeft) + indent;
            strBalancedMap = strBalancedMap.replaceAll("\n", "\n" + StringLib.blank(shiftRight + 1));
            if (oldShiftRight - shiftRight > 0) {
                strBalancedMap = strBalancedMap.substring(oldShiftRight - shiftRight);
            }
        } else {
            strBalancedMap = this.mapToSingleLine(this.mapAttributes);
        }
        if (this.getNumTuples() <= 0) {
            strbuf.append(StringLib.blank(indent));
            strbuf.append("<");
            strbuf.append(this.getTupleType());
            strbuf.append(" ");
            strbuf.append(strBalancedMap);
            strbuf.append(" />");
            return;
        }
        strbuf.append(StringLib.blank(indent));
        strbuf.append("<");
        strbuf.append(this.getTupleType());
        strbuf.append(" ");
        strbuf.append(strBalancedMap);
        strbuf.append(">");
    }

    protected void handleTuples(StringBuffer strbuf, int indent, boolean flagMulti) {
        Iterator it = this.tuples();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            strbuf.append("\n");
            t.toString(strbuf, indent + 3, flagMulti);
        }
    }

    protected void handleEndTag(StringBuffer strbuf, int indent) {
        if (this.getNumTuples() <= 0) {
            return;
        }
        strbuf.append("\n");
        strbuf.append(StringLib.blank(indent));
        strbuf.append("</");
        strbuf.append(this.getTupleType());
        strbuf.append(">\n");
    }

    public void toString(StringBuffer strbuf, int indent, boolean flagMulti) {
        this.updateSize();
        this.handleStartTag(strbuf, indent, flagMulti);
        this.handleTuples(strbuf, indent, flagMulti);
        this.handleEndTag(strbuf, indent);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean flagMultiLineAttributes) {
        StringBuffer strbuf = new StringBuffer();
        this.toString(strbuf, 0, flagMultiLineAttributes);
        return strbuf.toString();
    }

    public String toXml() {
        return this.toXml(true);
    }

    public String toXml(boolean flagMultiLineAttributes) {
        return this.toString(flagMultiLineAttributes);
    }

    public static Tuple getTestInstanceAAA() {
        return new Tuple("Empty");
    }

    public static Tuple getTestInstanceBBB() {
        Tuple t = new Tuple("Test");
        t.setAttribute("type", "location.room");
        t.setAttribute("description", "location of an entity");
        t.setAttribute("entity-name", "bart simpson");
        return t;
    }

    public static Tuple getTestInstanceCCC() {
        Tuple t = Tuple.getTestInstanceBBB();
        t.setDynamicSize(true);
        t.addTuple(Tuple.getTestInstanceAAA());
        t.addTuple(Tuple.getTestInstanceAAA());
        t.addTuple(Tuple.getTestInstanceBBB());
        return t;
    }

    public static Tuple getTestInstanceDDD() {
        Tuple t = Tuple.getTestInstanceCCC();
        t.addTuple(Tuple.getTestInstanceCCC());
        return t;
    }

    private static void printAndParseTuple(Tuple t) throws Exception {
        String strAA = t.toString();
        System.out.println("---the tuple------");
        System.out.println(strAA);
        System.out.println("---the parsed tuple------");
        Tuple ct2 = PARSER.parse(t.toString());
        System.out.println(ct2.getClass());
        String strBB = ct2.toString();
        System.out.println(strBB);
        System.out.println("--- equal? --- " + strAA.equals(strBB));
    }

    private void runTestAAA() {
        System.out.println(Tuple.getTestInstanceAAA());
        System.out.println();
        System.out.println(Tuple.getTestInstanceBBB());
        System.out.println();
        System.out.println(Tuple.getTestInstanceCCC());
        System.out.println();
        Tuple tZZ = new Tuple();
        Tuple tAA = Tuple.getTestInstanceAAA();
        Tuple tBB = Tuple.getTestInstanceBBB();
        Tuple tCC = Tuple.getTestInstanceCCC();
        tZZ.setTo(tAA);
        System.out.println(tZZ.equals(tAA));
        System.out.println(tZZ.equals(Tuple.getTestInstanceAAA()));
    }

    private static void runTestBBB() throws Exception {
        long startTime = System.currentTimeMillis();
        Tuple t = new Tuple("Test");
        System.out.println(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        t = Tuple.parse("<test value=\"blah\"></test>");
        System.out.println(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        t = Tuple.parse("<test2 value=\"blix\"></test2>");
        System.out.println(System.currentTimeMillis() - startTime);
    }

    private static void runTestCCC() throws Exception {
        System.out.println(Tuple.getTestInstanceBBB());
        System.out.println(Tuple.getTestInstanceBBB().getXPath("/Test/@description"));
        System.out.println(Tuple.getTestInstanceBBB().getXPath("/Test/@entity-name"));
        System.out.println(Tuple.getTestInstanceBBB().getXPath("/Test/@blah"));
        System.out.println("");
        System.out.println("");
        System.out.println(Tuple.getTestInstanceDDD());
        System.out.println(Tuple.getTestInstanceDDD().getXPath("/Test/Test"));
    }

    private static void runTestDDD() throws Exception {
        System.out.println(Tuple.getTestInstanceAAA().toString(false));
        System.out.println(Tuple.getTestInstanceBBB().toString(false));
        System.out.println(Tuple.getTestInstanceCCC().toString(false));
        System.out.println(Tuple.getTestInstanceDDD().toString(false));
    }

    private static void runTestEEE() throws Exception {
        Tuple t = Tuple.getTestInstanceAAA();
        System.out.println("-------------");
        System.out.println(t);
        System.out.println("-------------");
        System.out.println(t.getTuplesByType("blah"));
        System.out.println("-------------");
        t.removeTuplesByType("blah");
        System.out.println(t);
    }

    private static void runTestFFF() {
        System.out.println(Tuple.xmlEncode("1234567890"));
        System.out.println(Tuple.xmlEncode("&1234567&890"));
        System.out.println(Tuple.xmlEncode("<1234567&890>"));
    }

    private static void runTestGGG() throws Exception {
        Tuple t = new Tuple();
        t.setAttribute("keyAA", "valAA");
        t.setAttribute("keyAA", "val&amp;BB");
        t.setAttribute("keyAA", "&lt;html&gt;");
        System.out.println(t);
        System.out.println("------------------");
        t = new Tuple(Tuple.parse(t.toString()));
        System.out.println(t);
    }

    public static void main(String[] argv) throws Exception {
        Tuple.runTestGGG();
    }
}

