/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.tree;

import edu.berkeley.guir.lib.collection.tree.TreePath;
import edu.berkeley.guir.lib.collection.tree.TreeTraversalOp;
import edu.berkeley.guir.lib.collection.tree.TreeTraversalOpAllChildren;
import edu.berkeley.guir.lib.collection.tree.TreeTraversalOpLeafNodes;
import edu.berkeley.guir.lib.collection.tree.TreeTraversalOpToString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TreeNode {
    List children = new LinkedList();
    TreeNode parent = null;
    Object value = null;
    boolean flagIgnore = false;

    public TreeNode() {
    }

    public TreeNode(Object newValue) {
        this.setValue(newValue);
    }

    public TreeNode(TreeNode node) {
        this.children = (List)((LinkedList)node.children).clone();
        this.parent = node.parent;
        this.value = node.value;
        this.flagIgnore = node.flagIgnore;
    }

    public void setIgnore(boolean flag) {
        this.flagIgnore = flag;
    }

    public boolean isIgnored() {
        return this.flagIgnore;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void clearValue() {
        this.value = null;
    }

    public boolean containsValue(Object obj) {
        return obj.equals(this.value);
    }

    public void setParent(TreeNode node) {
        this.parent = node;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreePath getPathFromRoot() {
        TreeNode currNode = this;
        TreePath path = new TreePath();
        do {
            if (currNode.isIgnored()) continue;
            path.addToFront(currNode);
        } while ((currNode = currNode.getParent()) != null);
        return path;
    }

    public boolean isValidPath(TreePath path) {
        TreeNode node = this.getNodeFromPath(path);
        return node != null;
    }

    public TreeNode getNodeFromPath(TreePath path) {
        TreeNode currNode = this;
        Iterator it = path.values();
        while (it.hasNext()) {
            Object val = it.next();
            if ((currNode = currNode.getChild(val)) != null) continue;
            return null;
        }
        return currNode;
    }

    public void addChild(TreeNode node) {
        this.children.add(node);
        node.setParent(this);
    }

    public void addPath(TreePath path) {
        Iterator it = path.path();
        TreeNode curr = this;
        TreeNode next = null;
        while (it.hasNext()) {
            TreeNode pnode = (TreeNode)it.next();
            Object val = pnode.getValue();
            next = curr.getChild(val);
            if (next == null) {
                next = new TreeNode(val);
                curr.addChild(next);
            }
            curr = next;
            next = null;
        }
    }

    public boolean removePath(TreePath path) {
        TreeNode node = this.getNodeFromPath(path);
        if (node == null) {
            return false;
        }
        TreeNode parent = node.getParent();
        return parent.removeChild(node);
    }

    public TreeNode getChild(Object val) {
        Iterator it = this.children.iterator();
        TreeNode node = null;
        while (it.hasNext()) {
            node = (TreeNode)it.next();
            if (!val.equals(node.getValue())) continue;
            return node;
        }
        return null;
    }

    public boolean removeChild(TreeNode node) {
        node.setParent(null);
        return this.children.remove(node);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public TreeNode getChild(int n) {
        TreeNode node = (TreeNode)this.children.get(n);
        return node;
    }

    public int numChildren() {
        return this.children.size();
    }

    public Iterator children() {
        return this.children.iterator();
    }

    public List childrenAsList() {
        return new LinkedList(this.children);
    }

    public Iterator allChildrenPreOrder() {
        return this.allChildrenPreOrderAsList().iterator();
    }

    public List allChildrenPreOrderAsList() {
        TreeTraversalOpAllChildren op = new TreeTraversalOpAllChildren();
        this.preOrder(op);
        return op.childrenAsList();
    }

    public Iterator allChildrenPostOrder() {
        return this.allChildrenPostOrderAsList().iterator();
    }

    public List allChildrenPostOrderAsList() {
        TreeTraversalOpAllChildren op = new TreeTraversalOpAllChildren();
        this.postOrder(op);
        return op.childrenAsList();
    }

    public Iterator allChildrenBreadthOrder() {
        return this.allChildrenBreadthOrderAsList().iterator();
    }

    public List allChildrenBreadthOrderAsList() {
        TreeTraversalOpAllChildren op = new TreeTraversalOpAllChildren();
        this.breadthOrder(op);
        return op.childrenAsList();
    }

    public void preOrder(TreeTraversalOp op) {
        this.preOrderHelper(op, 0);
    }

    private void preOrderHelper(TreeTraversalOp op, int depth) {
        Iterator it = this.children.iterator();
        op.onNode(this, depth);
        while (it.hasNext()) {
            TreeNode node = (TreeNode)it.next();
            node.preOrderHelper(op, depth + 1);
        }
    }

    public void postOrder(TreeTraversalOp op) {
        this.postOrderHelper(op, 0);
    }

    private void postOrderHelper(TreeTraversalOp op, int depth) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            TreeNode node = (TreeNode)it.next();
            node.postOrderHelper(op, depth + 1);
        }
        op.onNode(this, depth);
    }

    public void breadthOrder(TreeTraversalOp op) {
        Iterator it;
        LinkedList<BreadthNode> searchQueue = new LinkedList<BreadthNode>();
        LinkedList<BreadthNode> currentQueue = new LinkedList<BreadthNode>();
        BreadthNode bnode = new BreadthNode(this, 0);
        currentQueue.add(bnode);
        while (currentQueue.size() > 0) {
            bnode = (BreadthNode)currentQueue.removeFirst();
            TreeNode node = bnode.node;
            int depth = bnode.depth;
            searchQueue.add(bnode);
            it = node.children();
            while (it.hasNext()) {
                node = (TreeNode)it.next();
                bnode = new BreadthNode(node, depth + 1);
                currentQueue.add(bnode);
            }
        }
        it = searchQueue.iterator();
        while (it.hasNext()) {
            bnode = (BreadthNode)it.next();
            op.onNode(bnode.node, bnode.depth);
        }
    }

    public Iterator getLeafNodes() {
        TreeTraversalOpLeafNodes op = new TreeTraversalOpLeafNodes();
        this.preOrder(op);
        return op.getLeafNodes();
    }

    public Iterator getLeafPaths() {
        Iterator it = this.getLeafNodes();
        LinkedList<TreePath> listPaths = new LinkedList<TreePath>();
        while (it.hasNext()) {
            TreeNode node = (TreeNode)it.next();
            TreePath path = node.getPathFromRoot();
            listPaths.add(path);
        }
        return listPaths.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TreeNode) {
            TreeNode node = (TreeNode)obj;
            Object valAA = node.getValue();
            Object valBB = this.getValue();
            if (valAA == null || valBB == null) {
                return valAA == valBB;
            }
            return valBB.equals(valAA);
        }
        return false;
    }

    public int hashCode() {
        if (this.getValue() == null) {
            return 0;
        }
        return this.getValue().hashCode();
    }

    public String toString() {
        return "{" + this.value;
    }

    public String toDebugString() {
        TreeTraversalOpToString op = new TreeTraversalOpToString();
        this.preOrder(op);
        return op.getString();
    }

    public static void main(String[] argv) {
        TreeNode nodeAA = new TreeNode(new Character('A'));
        TreeNode nodeBB = new TreeNode(new Character('B'));
        TreeNode nodeCC = new TreeNode(new Character('C'));
        TreeNode nodeDD = new TreeNode(new Character('D'));
        TreeNode nodeEE = new TreeNode(new Character('E'));
        TreeNode nodeFF = new TreeNode(new Character('F'));
        TreeNode nodeGG = new TreeNode(new Character('G'));
        TreeNode nodeHH = new TreeNode();
        nodeAA.addChild(nodeBB);
        nodeAA.addChild(nodeCC);
        nodeAA.addChild(nodeDD);
        nodeBB.addChild(nodeEE);
        nodeBB.addChild(nodeFF);
        nodeFF.addChild(nodeGG);
        nodeFF.addChild(nodeHH);
        System.out.println(nodeAA.toDebugString());
        System.out.println(nodeAA.numChildren());
        System.out.println("-----");
        nodeAA.setIgnore(true);
        System.out.println(nodeAA.toDebugString());
        System.out.println("-----");
        Iterator it = nodeAA.getLeafNodes();
        while (it.hasNext()) {
            System.out.println("--" + it.next());
        }
        System.out.println(nodeAA.getPathFromRoot());
        System.out.println(nodeBB.getPathFromRoot());
        System.out.println(nodeGG.getPathFromRoot());
        System.out.println(nodeHH.getPathFromRoot());
        System.out.println("-----");
        TreeNode nodeBBBB = new TreeNode(new Character('B'));
        TreeNode nodeEEEE = new TreeNode(new Character('E'));
        TreeNode nodeIIII = new TreeNode(new Character('I'));
        TreePath p = new TreePath(nodeBBBB, nodeEEEE, nodeIIII);
        System.out.println(p);
        System.out.println(nodeIIII.getPathFromRoot());
        nodeAA.addPath(p);
        System.out.println("-----");
        System.out.println(nodeIIII.getPathFromRoot());
        System.out.println(nodeAA.toDebugString());
        p = new TreePath(new Character('J'), new Character('K'));
        System.out.println(p);
        nodeAA.addPath(p);
        System.out.println(nodeAA.toDebugString());
        System.out.println("-----");
        TreeTraversalOpToString op1 = new TreeTraversalOpToString();
        TreeTraversalOpToString op2 = new TreeTraversalOpToString();
        TreeTraversalOpToString op3 = new TreeTraversalOpToString();
        nodeAA.preOrder(op1);
        nodeAA.postOrder(op2);
        nodeAA.breadthOrder(op3);
        System.out.println("pre");
        System.out.println(op1.getString());
        System.out.println("post");
        System.out.println(op2.getString());
        System.out.println("breadth");
        System.out.println(op3.getString());
        System.out.println("-----");
        nodeAA.removePath(p);
        System.out.println(nodeAA.toDebugString());
        nodeAA.removePath(nodeBB.getPathFromRoot());
        System.out.println(nodeAA.toDebugString());
    }

    static class BreadthNode {
        TreeNode node;
        int depth;

        public BreadthNode(TreeNode newNode, int newDepth) {
            this.node = newNode;
            this.depth = newDepth;
        }
    }
}

