/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.history;

import edu.berkeley.guir.lib.collection.history.History;
import edu.berkeley.guir.lib.collection.history.HistoryDefaultImpl;
import edu.berkeley.guir.lib.collection.history.HistoryEvent;
import edu.berkeley.guir.lib.collection.history.HistoryEventFilterByField;
import edu.berkeley.guir.lib.util.filter.DateFilter;
import edu.berkeley.guir.lib.util.filter.Filter;
import edu.berkeley.guir.lib.util.filter.ReverseFilter;
import edu.berkeley.guir.lib.util.filter.StringFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class HistoryLib {
    public static final DateFormat DEFAULT_DATEFORMAT;
    static DateFormat df;

    static {
        df = DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
    }

    public static void setDefaultDateFormat(DateFormat newDateFormat) {
        df = newDateFormat;
    }

    public static DateFormat getDefaultDateFormat() {
        return df;
    }

    private HistoryLib() {
    }

    public static History mergeOr(History historyAA, History historyBB, History hOut) {
        hOut.addAllEvents(historyAA);
        hOut.addAllEvents(historyBB);
        return hOut;
    }

    public static History mergeSubtract(History historyAA, History historyBB, History hOut) {
        Iterator it = historyBB.events();
        while (it.hasNext()) {
            HistoryEvent evt = (HistoryEvent)it.next();
            hOut.removeEvent(evt);
        }
        return hOut;
    }

    public static History mergeAnd(History historyAA, History historyBB, History hOut) {
        Iterator it = historyBB.events();
        while (it.hasNext()) {
            HistoryEvent evt = (HistoryEvent)it.next();
            if (!historyAA.containsEvent(evt)) continue;
            hOut.addEvent(evt);
        }
        return hOut;
    }

    public static History filter(History history, Filter f, History hOut) {
        Iterator it = history.events();
        while (it.hasNext()) {
            HistoryEvent evt = (HistoryEvent)it.next();
            if (!f.isAccepted(evt)) continue;
            hOut.addEvent(evt);
        }
        return hOut;
    }

    public static History filter(History history, Filter f) {
        return HistoryLib.filter(history, f, new HistoryDefaultImpl());
    }

    public static History filterByDate(History h, Date dStart, Date dEnd, History hOut) {
        HistoryEventFilterByField f = new HistoryEventFilterByField("date", new DateFilter(dStart, dEnd, df));
        return HistoryLib.filter(h, f, hOut);
    }

    public static History filterByDate(History h, Date dStart, Date dEnd) {
        return HistoryLib.filterByDate(h, dStart, dEnd, new HistoryDefaultImpl());
    }

    public static History filterAllAfterDate(History h, Date dEnd, History hOut) {
        HistoryEventFilterByField f = new HistoryEventFilterByField("date", new DateFilter(null, dEnd, df));
        return HistoryLib.filter(h, f, hOut);
    }

    public static History filterAllAfterDate(History h, Date dEnd) {
        return HistoryLib.filterAllAfterDate(h, dEnd, new HistoryDefaultImpl());
    }

    public static History filterAllBeforeDate(History h, Date dStart, History hOut) {
        HistoryEventFilterByField f = new HistoryEventFilterByField("date", new DateFilter(dStart, null, df));
        return HistoryLib.filter(h, f, hOut);
    }

    public static History filterAllBeforeDate(History h, Date dStart) {
        return HistoryLib.filterAllBeforeDate(h, dStart, new HistoryDefaultImpl());
    }

    public static History filterByField(History h, String strField, String strPattern, boolean flagAccept, History hOut) {
        Filter f = new HistoryEventFilterByField(strField, new StringFilter(strPattern));
        if (!flagAccept) {
            f = new ReverseFilter(f);
        }
        return HistoryLib.filter(h, f, hOut);
    }

    public static History filterByField(History h, String strField, String strPattern, boolean flagAccept) {
        return HistoryLib.filterByField(h, strField, strPattern, flagAccept, new HistoryDefaultImpl());
    }
}

