/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.history;

import edu.berkeley.guir.lib.collection.history.HistoryEvent;
import edu.berkeley.guir.lib.collection.history.HistoryEventParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class HistoryEventParserDefaultImpl
implements HistoryEventParser {
    String[] keyOrdering;

    protected HistoryEvent createNewHistoryEvent() {
        return new HistoryEvent();
    }

    public HistoryEventParserDefaultImpl() {
    }

    public HistoryEventParserDefaultImpl(String[] newKeyOrdering) {
        this.keyOrdering = newKeyOrdering;
    }

    protected String[] getKeyValue(String str) {
        String[] strKeyVal = new String[2];
        int index = str.indexOf("=");
        strKeyVal[0] = str.substring(0, index);
        strKeyVal[1] = str.substring(index + 1);
        return strKeyVal;
    }

    protected List getKeyValuePairs(String strLine) {
        StringTokenizer strtok = new StringTokenizer(strLine, "$");
        LinkedList<String[]> listPairs = new LinkedList<String[]>();
        while (strtok.hasMoreTokens()) {
            String strPair = strtok.nextToken();
            listPairs.add(this.getKeyValue(strPair));
        }
        return listPairs;
    }

    protected List getValues(String strLine) {
        StringTokenizer strtok = new StringTokenizer(strLine, "$");
        LinkedList<String[]> listPairs = new LinkedList<String[]>();
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String[] pair = new String[]{this.keyOrdering[i++], strtok.nextToken()};
            listPairs.add(pair);
        }
        return listPairs;
    }

    protected HistoryEvent parseLine(String strLine) {
        HistoryEvent evt = this.createNewHistoryEvent();
        List listPairs = this.keyOrdering == null ? this.getKeyValuePairs(strLine) : this.getValues(strLine);
        Iterator it = listPairs.iterator();
        while (it.hasNext()) {
            String[] strKeyVal = (String[])it.next();
            evt.setValue(strKeyVal[0], strKeyVal[1]);
        }
        return evt;
    }

    public List parse(InputStream istream) throws IOException {
        return this.parse(new InputStreamReader(istream));
    }

    public List parse(Reader rdr) throws IOException {
        String strLine;
        LinkedList<HistoryEvent> listEvents = new LinkedList<HistoryEvent>();
        BufferedReader brdr = rdr instanceof BufferedReader ? (BufferedReader)rdr : new BufferedReader(rdr);
        while ((strLine = brdr.readLine()) != null) {
            listEvents.add(this.parseLine(strLine));
        }
        return listEvents;
    }
}

