/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.history;

import edu.berkeley.guir.lib.collection.history.HistoryDefaultImpl;
import edu.berkeley.guir.lib.collection.history.HistoryEventParser;
import edu.berkeley.guir.lib.collection.history.HistoryEventParserDefaultImpl;
import edu.berkeley.guir.lib.collection.history.HistoryLib;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HistoryEvent {
    public static final String KEY_USER = "user";
    public static final String KEY_DATE = "date";
    public static final String VAL_DATE = "unknown";
    public static final String FIELD_DELIMITER = "$";
    public static final HistoryEventParser PARSER = new HistoryEventParserDefaultImpl();
    Map mapHistory = new HashMap(8);

    public HistoryEvent() {
        this.mapHistory.put(KEY_DATE, VAL_DATE);
    }

    public void setValue(String strKey, String strVal) {
        this.mapHistory.put(strKey, strVal);
    }

    public String getValue(String strKey) {
        String strVal = (String)this.mapHistory.get(strKey);
        return strVal;
    }

    public void setDate(String str) {
        this.setValue(KEY_DATE, str);
    }

    public void setDate(Date d) {
        this.setValue(KEY_DATE, HistoryLib.getDefaultDateFormat().format(d));
    }

    public String getDate() {
        return this.getValue(KEY_DATE);
    }

    public void touchDate() {
        this.setDate(new Date());
    }

    protected String[] getKeyOrdering() {
        Set setKeys = this.mapHistory.keySet();
        String[] strKeys = new String[setKeys.size()];
        int index = 0;
        strKeys[index++] = KEY_DATE;
        Iterator it = setKeys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (KEY_DATE.equals(key)) continue;
            strKeys[index++] = (String)key;
        }
        return strKeys;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean flagPrintKeys) {
        return this.toString(flagPrintKeys, this.getKeyOrdering());
    }

    public String toString(boolean flagPrintKeys, String[] keyOrdering) {
        StringBuffer strbuf = new StringBuffer();
        String[] strKeys = keyOrdering;
        int i = 0;
        while (i < strKeys.length) {
            String strVal = this.getValue(strKeys[i]);
            if (flagPrintKeys) {
                strbuf.append(strKeys[i]);
                strbuf.append("=");
            }
            strbuf.append(strVal);
            strbuf.append(FIELD_DELIMITER);
            ++i;
        }
        return strbuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent evt = (HistoryEvent)obj;
        return this.mapHistory.equals(evt.mapHistory);
    }

    public int compareTo(Object obj) {
        return HistoryDefaultImpl.DEFAULT_COMPARATOR.compare(this, obj);
    }

    public int hashCode() {
        return this.mapHistory.hashCode();
    }

    public static HistoryEvent getTestInstanceAAA() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "123");
        evt.setValue("val", "ABC");
        evt.setDate(new Date(523456789L));
        return evt;
    }

    public static HistoryEvent getTestInstanceBBB() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "234");
        evt.setValue("val", "BCD");
        evt.setDate(new Date(613456789L));
        return evt;
    }

    public static HistoryEvent getTestInstanceCCC() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "345");
        evt.setValue("val", "CDE");
        evt.setDate(new Date(711456789L));
        return evt;
    }

    public static HistoryEvent getTestInstanceDDD() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "456");
        evt.setValue("val", "DEF");
        evt.setDate(new Date(811156789L));
        return evt;
    }

    public static HistoryEvent getTestInstanceEEE() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "567");
        evt.setValue("val", "EFG");
        evt.setDate(new Date(911116789L));
        return evt;
    }

    public static HistoryEvent getTestInstanceFFF() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "678");
        evt.setValue("val", "FGH");
        evt.setDate(new Date(511111789L));
        return evt;
    }

    public static HistoryEvent getTestInstanceGGG() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "8910");
        evt.setValue("val", "GHI");
        evt.setDate(new Date(611111189L));
        return evt;
    }

    public static HistoryEvent getTestInstanceHHH() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "91011");
        evt.setValue("val", "HIJ");
        evt.setDate(new Date(711111119L));
        return evt;
    }

    public static HistoryEvent getTestInstanceIII() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "101112");
        evt.setValue("val", "IJK");
        evt.setDate(new Date(811111111L));
        return evt;
    }

    public static HistoryEvent getTestInstanceJJJ() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "111213");
        evt.setValue("val", "JKL");
        evt.setDate(new Date(911112111L));
        return evt;
    }

    public static HistoryEvent getTestInstanceKKK() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "121314");
        evt.setValue("val", "KLM");
        evt.setDate(new Date(111112211L));
        return evt;
    }

    public static HistoryEvent getTestInstanceLLL() {
        HistoryEvent evt = new HistoryEvent();
        evt.setValue("ID", "131415");
        evt.setValue("val", "LMN");
        evt.touchDate();
        return evt;
    }

    private static void test(HistoryEvent evt) {
        System.out.println(evt + " " + evt.hashCode());
    }

    private static void runTestAAA() {
        HistoryEvent.test(HistoryEvent.getTestInstanceAAA());
        HistoryEvent.test(HistoryEvent.getTestInstanceBBB());
        HistoryEvent.test(HistoryEvent.getTestInstanceCCC());
        HistoryEvent.test(HistoryEvent.getTestInstanceDDD());
        HistoryEvent.test(HistoryEvent.getTestInstanceEEE());
        HistoryEvent.test(HistoryEvent.getTestInstanceFFF());
        HistoryEvent.test(HistoryEvent.getTestInstanceGGG());
        HistoryEvent.test(HistoryEvent.getTestInstanceHHH());
        HistoryEvent.test(HistoryEvent.getTestInstanceIII());
        HistoryEvent.test(HistoryEvent.getTestInstanceJJJ());
        HistoryEvent.test(HistoryEvent.getTestInstanceKKK());
        HistoryEvent.test(HistoryEvent.getTestInstanceLLL());
    }

    private static void runTestBBB() {
        HistoryEvent evtAA = HistoryEvent.getTestInstanceAAA();
        HistoryEvent evtBB = HistoryEvent.getTestInstanceBBB();
        System.out.println(evtAA.equals(evtBB));
        evtBB = HistoryEvent.getTestInstanceCCC();
        System.out.println(evtAA.equals(evtBB));
        evtBB = HistoryEvent.getTestInstanceDDD();
        System.out.println(evtAA.equals(evtBB));
        evtBB = HistoryEvent.getTestInstanceEEE();
        System.out.println(evtAA.equals(evtBB));
    }

    private static void runTestCCC() {
        HistoryEvent evtAA = HistoryEvent.getTestInstanceAAA();
        HistoryEvent evtBB = HistoryEvent.getTestInstanceBBB();
        System.out.println(evtAA.compareTo(evtBB));
        evtBB = HistoryEvent.getTestInstanceCCC();
        System.out.println(evtAA.compareTo(evtBB));
        evtBB = HistoryEvent.getTestInstanceDDD();
        System.out.println(evtAA.compareTo(evtBB));
        evtBB = HistoryEvent.getTestInstanceEEE();
        System.out.println(evtAA.compareTo(evtBB));
    }

    public static void main(String[] argv) throws Exception {
        HistoryEvent.runTestCCC();
    }
}

