/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.history;

import edu.berkeley.guir.lib.collection.history.History;
import edu.berkeley.guir.lib.collection.history.HistoryEvent;
import edu.berkeley.guir.lib.collection.history.HistoryEventDateComparator;
import edu.berkeley.guir.lib.collection.history.HistoryEventParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class HistoryDefaultImpl
implements History {
    public static final Comparator DEFAULT_COMPARATOR = new HistoryEventDateComparator();
    public static final int ORDER_FIRST = 15;
    public static final int ORDER_LAST = 19;
    SortedSet setEvents;

    public HistoryDefaultImpl() {
        this(DEFAULT_COMPARATOR);
    }

    public HistoryDefaultImpl(Collection col) {
        this(col, DEFAULT_COMPARATOR);
    }

    public HistoryDefaultImpl(History h) {
        this(h, DEFAULT_COMPARATOR);
    }

    public HistoryDefaultImpl(Reader rdr, HistoryEventParser parser) throws IOException {
        this(rdr, parser, DEFAULT_COMPARATOR);
    }

    public HistoryDefaultImpl(Comparator c) {
        this.setEvents = new TreeSet(c);
    }

    public HistoryDefaultImpl(Collection col, Comparator c) {
        this(c);
        this.addAllEvents(col.iterator());
    }

    public HistoryDefaultImpl(History h, Comparator c) {
        this(c);
        this.addAllEvents(h);
    }

    public HistoryDefaultImpl(Reader rdr, HistoryEventParser p, Comparator c) throws IOException {
        this(c);
        List listEvents = p.parse(rdr);
        Iterator it = listEvents.iterator();
        while (it.hasNext()) {
            this.addEvent((HistoryEvent)it.next());
        }
    }

    public void addEvent(HistoryEvent evt) {
        this.setEvents.add(evt);
    }

    public void addAllEvents(History history) {
        this.addAllEvents(history.events());
    }

    public void addAllEvents(Collection events) {
        this.addAllEvents(events.iterator());
    }

    public void addAllEvents(Iterator it) {
        while (it.hasNext()) {
            HistoryEvent evt = (HistoryEvent)it.next();
            this.addEvent(evt);
        }
    }

    public void removeEvent(HistoryEvent evt) {
        this.setEvents.remove(evt);
    }

    public void removeEvent(int index) {
        this.setEvents.remove(this.getEvent(index));
    }

    public void clearEvents() {
        this.setEvents.clear();
    }

    public boolean containsEvent(HistoryEvent evt) {
        return this.setEvents.contains(evt);
    }

    public HistoryEvent getEvent(int index) {
        Iterator it = this.events();
        int count = 0;
        while (it.hasNext()) {
            HistoryEvent evt = (HistoryEvent)it.next();
            if (count == index) {
                return evt;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    public int size() {
        return this.setEvents.size();
    }

    public Iterator events() {
        return this.events(true);
    }

    public Iterator events(boolean flagForward) {
        if (flagForward) {
            return this.setEvents.iterator();
        }
        LinkedList list = new LinkedList(this.setEvents);
        Collections.reverse(list);
        return list.iterator();
    }

    public List asList() {
        return new LinkedList(this.setEvents);
    }

    public HistoryEvent getFirstEntry() {
        return (HistoryEvent)this.setEvents.first();
    }

    public HistoryEvent getLastEntry() {
        return (HistoryEvent)this.setEvents.last();
    }

    public HistoryEvent getByField(boolean flagForward, String strField, String strVal) {
        Iterator it = this.events(flagForward);
        while (it.hasNext()) {
            HistoryEvent evt = (HistoryEvent)it.next();
            String strEvtVal = evt.getValue(strField);
            if (strEvtVal == null || !strEvtVal.equals(strVal)) continue;
            return evt;
        }
        return null;
    }

    public String toString(HistoryEvent evt) {
        return evt.toString();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.events();
        while (it.hasNext()) {
            strbuf.append(this.toString((HistoryEvent)it.next()));
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    public void toWriter(Writer wtr) throws IOException {
        Iterator it = this.events();
        while (it.hasNext()) {
            wtr.write(this.toString((HistoryEvent)it.next()));
            wtr.write("\n");
        }
    }

    public static History getTestInstanceAAA() {
        HistoryDefaultImpl hist = new HistoryDefaultImpl();
        hist.addEvent(HistoryEvent.getTestInstanceAAA());
        hist.addEvent(HistoryEvent.getTestInstanceBBB());
        hist.addEvent(HistoryEvent.getTestInstanceCCC());
        hist.addEvent(HistoryEvent.getTestInstanceDDD());
        hist.addEvent(HistoryEvent.getTestInstanceEEE());
        hist.addEvent(HistoryEvent.getTestInstanceFFF());
        hist.addEvent(HistoryEvent.getTestInstanceGGG());
        hist.addEvent(HistoryEvent.getTestInstanceHHH());
        hist.addEvent(HistoryEvent.getTestInstanceIII());
        hist.addEvent(HistoryEvent.getTestInstanceJJJ());
        hist.addEvent(HistoryEvent.getTestInstanceKKK());
        hist.addEvent(HistoryEvent.getTestInstanceLLL());
        return hist;
    }

    private static void runTestAAA() {
        History hist = HistoryDefaultImpl.getTestInstanceAAA();
        System.out.println(hist);
        System.out.println();
        System.out.println(hist.getFirstEntry());
        System.out.println();
        System.out.println(hist.getLastEntry());
    }

    private static void runTestBBB() {
        History hist = HistoryDefaultImpl.getTestInstanceAAA();
        Iterator it = hist.events(false);
        System.out.println(hist);
        System.out.println();
        System.out.println();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public static void main(String[] argv) throws Exception {
        HistoryDefaultImpl.runTestBBB();
    }
}

