/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.Queue;
import edu.berkeley.guir.lib.collection.graph.Graph;
import edu.berkeley.guir.lib.collection.graph.GraphNode;
import edu.berkeley.guir.lib.collection.graph.GraphPath;
import edu.berkeley.guir.lib.collection.graph.GraphSearch;
import java.util.Iterator;

public class GraphSearchBreadthFirst
implements GraphSearch {
    Graph g;

    public GraphPath search(Graph g, String strFrom, String strTo) {
        GraphPath p = new GraphPath();
        this.g = g;
        if (g.nodeExists(strFrom) && g.nodeExists(strTo)) {
            p = this.breadthFirstSearchHelper(strFrom, strTo);
        }
        return p;
    }

    private GraphPath breadthFirstSearchHelper(String strFrom, String strTo) {
        Queue q = new Queue();
        GraphPath p = new GraphPath();
        try {
            p.addNode(this.g.getNode(strFrom));
            q.enqueue(p);
            while (q.size() > 0) {
                p = (GraphPath)q.dequeue();
                GraphNode nodeAt = p.getLastNode();
                Iterator it = nodeAt.getOutlinks();
                while (it.hasNext()) {
                    GraphPath newpath = (GraphPath)p.clone();
                    String strNodeNext = (String)it.next();
                    GraphNode nodeNext = this.g.getNode(strNodeNext);
                    newpath.addNode(nodeNext, this.g.getWeight(nodeAt, nodeNext));
                    if (strTo.equals(nodeNext.getName())) {
                        return newpath;
                    }
                    q.enqueue(newpath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            p = new GraphPath();
        }
        return new GraphPath();
    }
}

