/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.Queue;
import edu.berkeley.guir.lib.collection.graph.Graph;
import edu.berkeley.guir.lib.collection.graph.GraphNode;
import edu.berkeley.guir.lib.collection.graph.GraphPath;
import edu.berkeley.guir.lib.collection.graph.GraphSearch;
import java.util.HashMap;
import java.util.Iterator;

public class GraphSearchBidirBlind
implements GraphSearch {
    Graph g;
    HashMap table = new HashMap(1000);
    HashMap mapForward = new HashMap(1000);
    HashMap mapBackward = new HashMap(1000);
    Queue qForward = new Queue();
    Queue qBackward = new Queue();

    public void clear() {
        this.qForward.clear();
        this.qBackward.clear();
        this.mapForward.clear();
        this.mapBackward.clear();
    }

    public GraphPath search(Graph g, String strFrom, String strTo) {
        GraphPath p = null;
        boolean flagForward = true;
        boolean flagFound = false;
        this.g = g;
        this.mapForward.clear();
        this.mapBackward.clear();
        this.qForward.clear();
        this.qBackward.clear();
        GraphPath pathFinal = new GraphPath();
        try {
            if (g.nodeExists(strFrom) && g.nodeExists(strTo)) {
                p = new GraphPath();
                p.addNode(g.getNode(strFrom));
                this.qForward.enqueue(p);
                this.mapForward.put(strFrom, p);
                p = new GraphPath();
                p.addNode(g.getNode(strTo));
                this.qBackward.enqueue(p);
                this.mapBackward.put(strTo, p);
                while (!flagFound && this.qForward.size() > 0 && this.qBackward.size() > 0) {
                    String strNodeNext;
                    GraphPath newpath;
                    Iterator it;
                    String strNodeAt;
                    GraphNode nodeAt;
                    if (flagForward) {
                        p = (GraphPath)this.qForward.dequeue();
                        nodeAt = p.getLastNode();
                        strNodeAt = nodeAt.getName();
                        it = nodeAt.getOutlinks();
                        while (it.hasNext()) {
                            newpath = (GraphPath)p.clone();
                            strNodeNext = (String)it.next();
                            newpath.addNode(g.getNode(strNodeNext), g.getWeight(strNodeAt, strNodeNext));
                            if (this.mapBackward.containsKey(strNodeNext)) {
                                GraphPath pBackward = (GraphPath)this.mapBackward.get(strNodeNext);
                                pathFinal = this.assemblePath(newpath, pBackward);
                                flagFound = true;
                                continue;
                            }
                            this.qForward.enqueue(newpath);
                            this.mapForward.put(strNodeNext, newpath);
                        }
                        flagForward = false;
                        continue;
                    }
                    p = (GraphPath)this.qBackward.dequeue();
                    nodeAt = p.getLastNode();
                    strNodeAt = nodeAt.getName();
                    it = nodeAt.getInlinks();
                    while (it.hasNext()) {
                        newpath = (GraphPath)p.clone();
                        strNodeNext = (String)it.next();
                        newpath.addNode(g.getNode(strNodeNext), g.getWeight(strNodeNext, strNodeAt));
                        if (this.mapForward.containsKey(strNodeNext)) {
                            GraphPath pForward = (GraphPath)this.mapForward.get(strNodeNext);
                            pathFinal = this.assemblePath(pForward, newpath);
                            flagFound = true;
                            continue;
                        }
                        this.qBackward.enqueue(newpath);
                        this.mapBackward.put(strNodeNext, newpath);
                    }
                    flagForward = true;
                }
            }
        }
        catch (Exception e) {
            pathFinal = new GraphPath();
        }
        return pathFinal;
    }

    private GraphPath assemblePath(GraphPath pathForward, GraphPath pathBackward) {
        Iterator itNodes = pathBackward.getNodesReversed();
        Iterator itWeights = pathBackward.getWeightsReversed();
        GraphPath p = (GraphPath)pathForward.clone();
        itNodes.next();
        while (itNodes.hasNext()) {
            Float weight = (Float)itWeights.next();
            p.addNode((GraphNode)itNodes.next(), weight.floatValue());
        }
        return p;
    }
}

