/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.graph.BinaryTree;
import edu.berkeley.guir.lib.collection.graph.GraphNode;
import edu.berkeley.guir.lib.collection.graph.GraphPath;
import edu.berkeley.guir.lib.collection.graph.GraphPathTreeFormatter;
import edu.berkeley.guir.lib.collection.graph.GraphPathTreeFormatterDefault;
import edu.berkeley.guir.lib.util.StringLib;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;

public class GraphPathTree
extends BinaryTree
implements Serializable,
Cloneable {
    private static final int INDENT = 3;
    GraphPathTreeFormatter formatter = new GraphPathTreeFormatterDefault();
    int numNodes = 0;
    int numHits = 0;
    int numLeaves = 0;

    public void setDefaultFormatter(GraphPathTreeFormatter f) {
        if (f != null) {
            this.formatter = f;
        }
    }

    public GraphPathTree() {
        super(new GraphNode("error - should not see this"));
    }

    protected GraphPathTree(GraphNode node) {
        super(node);
    }

    public void addPath(GraphPath p) {
        GraphPathTree newroot = null;
        GraphPathTree prev = null;
        int numNewNodes = p.length();
        Iterator it = p.getNodesReversed();
        while (it.hasNext()) {
            newroot = new GraphPathTree((GraphNode)it.next());
            newroot.setChild(prev);
            prev = newroot;
        }
        if (this.child() == null) {
            this.addChild(newroot);
            this.numNodes += numNewNodes;
            return;
        }
        GraphPathTree search = null;
        GraphPathTree current = this.child();
        boolean flagCommon = false;
        while (newroot != null) {
            search = current.hasSibling(newroot);
            if (search == null && (search = current.hasChild(newroot)) == null) {
                if (flagCommon) {
                    current.addChild(newroot);
                } else {
                    current.addSibling(newroot);
                }
                ++this.numHits;
                break;
            }
            --numNewNodes;
            newroot = newroot.child();
            current = search;
            flagCommon = true;
        }
        this.numNodes += numNewNodes;
    }

    protected void setChild(GraphPathTree ptree) {
        this.setRight(ptree);
    }

    protected void setSibling(GraphPathTree ptree) {
        this.setLeft(ptree);
    }

    protected void setData(GraphNode node) {
        this.setData(node);
    }

    private void addSibling(GraphPathTree ptree) {
        if (this.sibling() == null) {
            this.setSibling(ptree);
        } else {
            this.sibling().addSibling(ptree);
        }
    }

    private void addChild(GraphPathTree ptree) {
        if (this.child() == null) {
            this.setChild(ptree);
        } else {
            this.child().addSibling(ptree);
        }
    }

    public int getNumOfNodes() {
        return this.numNodes;
    }

    public int getNumOfLeaves() {
        return this.numLeaves;
    }

    public int getNumOfHits() {
        return this.numHits;
    }

    protected GraphPathTree hasChild(GraphPathTree ptree) {
        GraphPathTree current = this.child();
        while (current != null) {
            if (current.data().equals(ptree.data())) {
                return current;
            }
            current = current.sibling();
        }
        return null;
    }

    protected GraphPathTree hasSibling(GraphPathTree ptree) {
        GraphPathTree current = this;
        while (current != null) {
            if (current.data().equals(ptree.data())) {
                return current;
            }
            current = current.sibling();
        }
        return null;
    }

    protected GraphNode data() {
        return (GraphNode)this.getData();
    }

    protected GraphPathTree child() {
        return (GraphPathTree)this.getRight();
    }

    protected GraphPathTree sibling() {
        return (GraphPathTree)this.getLeft();
    }

    public Iterator inOrderTraversal() {
        if (this.child() != null) {
            return this.child().inOrderTraversalHelper();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private Iterator inOrderTraversalHelper() {
        return super.inOrderTraversal();
    }

    public Iterator preOrderTraversal() {
        if (this.child() != null) {
            return this.child().preOrderTraversalHelper();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private Iterator preOrderTraversalHelper() {
        return super.preOrderTraversal();
    }

    public Iterator postOrderTraversal() {
        if (this.child() != null) {
            return this.child().postOrderTraversalHelper();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private Iterator postOrderTraversalHelper() {
        return super.postOrderTraversal();
    }

    public void printReverseOrderTraversal() {
        this.printReverseOrderTraversal(new PrintWriter(System.out));
    }

    public void printReverseOrderTraversal(PrintWriter pwriter) {
        this.child().printReverseOrderTraversalHelper(pwriter, 1);
        pwriter.flush();
    }

    private void printReverseOrderTraversalHelper(PrintWriter pwriter, int depth) {
        String strPrefix = StringLib.spaces(3 * depth);
        pwriter.println(StringLib.fold(strPrefix, this.data().toString()));
        if (this.child() != null) {
            this.child().printReverseOrderTraversalHelper(pwriter, depth + 1);
        }
        if (this.sibling() != null) {
            this.sibling().printReverseOrderTraversalHelper(pwriter, depth);
        }
    }

    public void printTraversal() {
        this.printTraversal(this.formatter);
    }

    public void printTraversal(GraphPathTreeFormatter f) {
        this.printTraversal(new PrintWriter(System.out), f);
    }

    public void printTraversal(PrintWriter pwriter) {
        this.printTraversal(pwriter, this.formatter);
    }

    public void printTraversal(PrintWriter pwriter, GraphPathTreeFormatter f) {
        f.onStart(pwriter);
        if (this.child() != null) {
            this.child().printTraversalHelper(pwriter, 1, f);
        }
        f.onFinish(pwriter);
        pwriter.flush();
    }

    private void printTraversalHelper(PrintWriter pwriter, int depth, GraphPathTreeFormatter f) {
        f.onStartOfNode(pwriter, depth);
        if (this.child() == null) {
            f.onLeaf(pwriter, this.data(), depth);
        } else {
            f.onNode(pwriter, this.data(), depth);
            this.child().printTraversalHelper(pwriter, depth + 1, f);
        }
        f.onBacktrack(pwriter, depth);
        if (this.sibling() != null) {
            this.sibling().printTraversalHelper(pwriter, depth, f);
        }
        f.onEndOfNode(pwriter, depth);
    }

    public Object clone() {
        return null;
    }

    public boolean equals(Object obj) {
        return false;
    }
}

