/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.graph.GraphNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class GraphPath
implements Serializable,
Cloneable {
    private static final Float DEFAULT_WEIGHT_OBJECT = new Float(1.0f);
    LinkedList listNodes = new LinkedList();
    LinkedList listWeights = new LinkedList();
    HashMap mapNodesTemp = new HashMap();

    public Iterator getNodes() {
        return this.listNodes.iterator();
    }

    public Iterator getNodesReversed() {
        return new ReverseIterator(this.listNodes);
    }

    public Iterator getWeights() {
        return this.listWeights.iterator();
    }

    public Iterator getWeightsReversed() {
        return new ReverseIterator(this.listWeights);
    }

    public float totalWeight() {
        float dSumWeight = 0.0f;
        Iterator it = this.getWeights();
        while (it.hasNext()) {
            Float floatWeight = (Float)it.next();
            dSumWeight += floatWeight.floatValue();
        }
        return dSumWeight;
    }

    public boolean isCycle() {
        this.mapNodesTemp.clear();
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            Object node = it.next();
            if (this.mapNodesTemp.get(node) != null) {
                return true;
            }
            this.mapNodesTemp.put(node, Boolean.TRUE);
        }
        return false;
    }

    public boolean contains(GraphNode node) {
        return this.contains(node.getName());
    }

    public boolean contains(String strNodeName) {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            if (!strNodeName.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    public GraphNode getLastNode() {
        int size = this.listNodes.size();
        if (size == 0) {
            return null;
        }
        return (GraphNode)this.listNodes.getLast();
    }

    public int length() {
        return this.listNodes.size();
    }

    public void addNode(GraphNode node) {
        this.addNode(node, DEFAULT_WEIGHT_OBJECT);
    }

    public void addNode(GraphNode node, float weight) {
        this.addNode(node, new Float(weight));
    }

    public void removeLastNode() {
        int index = this.listNodes.size() - 1;
        if (index >= 0) {
            this.listNodes.removeLast();
            if (index >= 1) {
                this.listWeights.removeLast();
            }
        }
    }

    public void addNode(GraphNode node, Float weight) {
        if (this.listNodes.size() > 0) {
            this.listWeights.add(weight);
        }
        this.listNodes.add(node);
    }

    public String toString() {
        Iterator itWeights = this.getWeights();
        Iterator itNodes = this.getNodes();
        StringBuffer strbufReturn = new StringBuffer("[");
        try {
            while (itNodes.hasNext()) {
                GraphNode node = (GraphNode)itNodes.next();
                strbufReturn.append("\n");
                strbufReturn.append("  " + node.getName());
                strbufReturn.append(" (" + itWeights.next() + ") ->");
            }
        }
        catch (NoSuchElementException e) {
            strbufReturn.append("\n");
        }
        catch (Exception e) {
            return "[exception]";
        }
        strbufReturn.append("]");
        return strbufReturn.toString();
    }

    public Object clone() {
        GraphPath cloned = new GraphPath();
        cloned.listNodes = new LinkedList(this.listNodes);
        cloned.listWeights = new LinkedList(this.listWeights);
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraphPath) {
            GraphPath temp = (GraphPath)obj;
            try {
                int len = this.listNodes.size();
                int i = 0;
                while (i < len) {
                    if (!this.listNodes.get(i).equals(temp.listNodes.get(i))) {
                        return false;
                    }
                    ++i;
                }
                len = this.listWeights.size();
                i = 0;
                while (i < len) {
                    if (!this.listWeights.get(i).equals(temp.listWeights.get(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    class ReverseIterator
    implements Iterator {
        List list;
        int index;

        public ReverseIterator(List list) {
            this.list = list;
            this.index = list.size() - 1;
        }

        public boolean hasNext() {
            return this.index >= 0;
        }

        public Object next() {
            return this.list.get(this.index--);
        }

        public void remove() {
            this.list.remove(this.index);
        }
    }
}

