/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.graph.Graph;
import edu.berkeley.guir.lib.collection.graph.GraphEdge;
import edu.berkeley.guir.lib.collection.graph.GraphEdgeParser;
import edu.berkeley.guir.lib.collection.graph.GraphNode;
import edu.berkeley.guir.lib.collection.graph.GraphNodeParser;
import edu.berkeley.guir.lib.collection.graph.GraphParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class GraphParserDefaultImpl
implements GraphParser {
    private static final String NODES = "NODES";
    private static final String EDGES = "EDGES";
    private static final String UNDIRECTED_EDGES = "UNDIRECTED-EDGES";

    protected Graph createNewGraph() {
        return new Graph();
    }

    public Graph parse(Reader rdr) throws IOException {
        return this.parse(rdr, GraphNode.PARSER, GraphEdge.PARSER);
    }

    public Graph parse(Reader rdr, GraphNodeParser nparser, GraphEdgeParser eparser) throws IOException {
        String strLine;
        Graph g = this.createNewGraph();
        boolean flagNodes = true;
        boolean flagDirected = true;
        BufferedReader brdr = rdr instanceof BufferedReader ? (BufferedReader)rdr : new BufferedReader(rdr);
        while ((strLine = brdr.readLine()) != null) {
            if (NODES.equals(strLine)) {
                flagNodes = true;
                continue;
            }
            if (EDGES.equals(strLine)) {
                flagNodes = false;
                flagDirected = true;
                continue;
            }
            if (UNDIRECTED_EDGES.equals(strLine)) {
                flagNodes = false;
                flagDirected = false;
                continue;
            }
            if (flagNodes) {
                GraphNode node = nparser.parse(strLine);
                g.addNode(node);
                continue;
            }
            GraphEdge edge = eparser.parse(strLine);
            if (flagDirected) {
                g.addDirectedEdge(edge);
                continue;
            }
            g.addUndirectedEdge(edge);
        }
        return g;
    }
}

