/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.graph.GraphNodeParser;
import edu.berkeley.guir.lib.collection.graph.GraphNodeParserDefaultImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class GraphNode
implements Serializable,
Cloneable {
    private static final Float DEFAULT_INLINK_WEIGHT = new Float(-1.0f);
    private static final Float DEFAULT_OUTLINK_WEIGHT = new Float(1.0f);
    private static final float LOAD_FACTOR = 1.0f;
    public static final GraphNodeParser PARSER = new GraphNodeParserDefaultImpl();
    private static int iNumEdges = 10;
    private static boolean flagPrintLinks = true;
    private String strName;
    private HashMap mapOutlinks = null;
    private HashMap mapInlinks = null;

    public static void setDefaultNumberOfEdges(int numEdges) {
        if (iNumEdges > 10) {
            iNumEdges = numEdges;
        }
    }

    public static void setPrintLinks(boolean flag) {
        flagPrintLinks = flag;
    }

    protected GraphNode() {
        this.strName = "";
    }

    public GraphNode(String strName) {
        this.strName = strName.intern();
    }

    private void initOutlinks() {
        if (this.mapOutlinks == null) {
            this.mapOutlinks = new HashMap(iNumEdges, 1.0f);
        }
    }

    private void initInlinks() {
        if (this.mapInlinks == null) {
            this.mapInlinks = new HashMap(iNumEdges, 1.0f);
        }
    }

    public String getName() {
        return this.strName;
    }

    public Iterator getOutlinks() {
        if (this.mapOutlinks == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.mapOutlinks.keySet().iterator();
    }

    public Iterator getInlinks() {
        if (this.mapInlinks == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.mapInlinks.keySet().iterator();
    }

    public int getOutDegree() {
        if (this.mapOutlinks == null) {
            return 0;
        }
        return this.mapOutlinks.size();
    }

    public int getInDegree() {
        if (this.mapInlinks == null) {
            return 0;
        }
        return this.mapInlinks.size();
    }

    public boolean hasOutlinkTo(String strName) {
        if (this.mapOutlinks == null) {
            return false;
        }
        return this.mapOutlinks.containsKey(strName);
    }

    public boolean hasInlinkFrom(String strName) {
        if (this.mapInlinks == null) {
            return false;
        }
        return this.mapInlinks.containsKey(strName);
    }

    public float getOutlinkWeight(String strName) {
        if (this.mapOutlinks == null) {
            return Float.NaN;
        }
        Float weight = (Float)this.mapOutlinks.get(strName);
        if (weight == null) {
            return Float.NaN;
        }
        return weight.floatValue();
    }

    public float getInlinkWeight(String strName) {
        if (this.mapInlinks == null) {
            return Float.NaN;
        }
        Float weight = (Float)this.mapInlinks.get(strName);
        if (weight == null) {
            return Float.NaN;
        }
        return weight.floatValue();
    }

    public void setName(String strName) {
        this.strName = strName;
    }

    protected void addOutlink(String strNodeToName) {
        this.initOutlinks();
        this.mapOutlinks.put(strNodeToName.intern(), DEFAULT_OUTLINK_WEIGHT);
    }

    protected void addOutlink(String strNodeToName, float weight) {
        this.initOutlinks();
        this.mapOutlinks.put(strNodeToName.intern(), new Float(weight));
    }

    protected void addInlink(String strNodeToName) {
        this.initInlinks();
        this.mapInlinks.put(strNodeToName.intern(), DEFAULT_INLINK_WEIGHT);
    }

    protected void addInlink(String strNodeToName, float weight) {
        this.initInlinks();
        this.mapInlinks.put(strNodeToName.intern(), new Float(weight));
    }

    void removeInlink(String strName) {
        if (this.mapInlinks == null) {
            return;
        }
        this.mapInlinks.remove(strName);
    }

    void removeOutlink(String strName) {
        if (this.mapOutlinks == null) {
            return;
        }
        this.mapOutlinks.remove(strName);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator itOut = this.getOutlinks();
        Iterator itIn = this.getInlinks();
        strbuf.append(String.valueOf(this.strName) + "\n");
        if (flagPrintLinks) {
            Object key;
            strbuf.append(" " + this.getOutDegree() + " outlinks\n");
            while (itOut.hasNext()) {
                key = itOut.next();
                strbuf.append(" ( ");
                strbuf.append(this.getOutlinkWeight((String)key));
                strbuf.append(" ");
                strbuf.append(key);
                strbuf.append(" )\n");
            }
            strbuf.append(" " + this.getInDegree() + " inlinks\n");
            while (itIn.hasNext()) {
                key = itIn.next();
                strbuf.append(" ( ");
                strbuf.append(this.getInlinkWeight((String)key));
                strbuf.append(" ");
                strbuf.append(key);
                strbuf.append(" )\n");
            }
        }
        return strbuf.toString();
    }

    public Object clone() {
        GraphNode cloned = new GraphNode();
        if (this.strName != null) {
            cloned.strName = this.strName.intern();
        }
        cloned.mapOutlinks = (HashMap)this.mapOutlinks.clone();
        cloned.mapInlinks = (HashMap)this.mapInlinks.clone();
        return cloned;
    }

    public boolean equals(Object obj) {
        GraphNode temp;
        return obj instanceof GraphNode && this.strName.equals((temp = (GraphNode)obj).getName());
    }
}

