/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.graph.GraphEdgeParser;
import edu.berkeley.guir.lib.collection.graph.GraphEdgeParserDefaultImpl;
import edu.berkeley.guir.lib.collection.graph.GraphNode;
import java.io.Serializable;

public class GraphEdge
implements Serializable {
    public static final GraphEdgeParser PARSER = new GraphEdgeParserDefaultImpl();
    GraphNode nodeSrc;
    GraphNode nodeDst;
    float weight = 0.0f;

    public GraphEdge(String strNodeSrc, String strNodeDst) {
        this(new GraphNode(strNodeSrc), new GraphNode(strNodeDst), 1.0f);
    }

    public GraphEdge(String strNodeSrc, String strNodeDst, float weight) {
        this(new GraphNode(strNodeSrc), new GraphNode(strNodeDst), weight);
    }

    public GraphEdge(GraphNode nodeSrc, GraphNode nodeDst) {
        this(nodeSrc, nodeDst, 1.0f);
    }

    public GraphEdge(GraphNode nodeSrc, GraphNode nodeDst, float weight) {
        this.nodeSrc = nodeSrc;
        this.nodeDst = nodeDst;
        this.weight = weight;
    }

    public GraphNode getSourceNode() {
        return this.nodeSrc;
    }

    public GraphNode getDestNode() {
        return this.nodeDst;
    }

    public float getWeight() {
        return this.weight;
    }

    public int hashCode() {
        String strValue = String.valueOf(this.nodeSrc.toString()) + this.nodeDst.toString();
        return strValue.hashCode();
    }

    public String toString() {
        return String.valueOf(this.nodeSrc.getName()) + ", " + this.nodeDst.getName() + ", " + this.weight;
    }

    public boolean equals(Object o) {
        if (o instanceof GraphEdge) {
            GraphEdge edgeTemp = (GraphEdge)o;
            if (this.nodeSrc.equals(edgeTemp.nodeSrc) && this.nodeDst.equals(edgeTemp.nodeDst) && Math.abs(this.weight - edgeTemp.weight) < 0.001f) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] argv) {
        GraphEdge e1 = new GraphEdge("from", "to");
        GraphEdge e2 = new GraphEdge("alsofrom", "alsoto", 10.0f);
        GraphEdge e3 = new GraphEdge("alsofrom", "alsoto", 10.0f);
        GraphEdge e4 = new GraphEdge("alsofrom", "alsoto", 3.14159f);
        System.out.println(e1);
        System.out.println(e2);
        System.out.println(e3);
        System.out.println(e4);
        System.out.println(e2.equals(e3));
    }
}

