/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.graph;

import edu.berkeley.guir.lib.collection.graph.GraphEdge;
import edu.berkeley.guir.lib.collection.graph.GraphNode;
import edu.berkeley.guir.lib.collection.graph.GraphParser;
import edu.berkeley.guir.lib.collection.graph.GraphParserDefaultImpl;
import edu.berkeley.guir.lib.collection.graph.GraphPath;
import edu.berkeley.guir.lib.collection.graph.GraphSearchBidirBlind;
import edu.berkeley.guir.lib.collection.graph.GraphSearchBreadthFirst;
import edu.berkeley.guir.lib.collection.graph.GraphSearchDepthFirst;
import java.io.FileReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class Graph
implements Serializable {
    public static final GraphParser PARSER = new GraphParserDefaultImpl();
    private static int iNumGraphNodes = 1000;
    HashMap mapGraphNodes = new HashMap(iNumGraphNodes);

    public static void setDefaultNumberOfGraphNodes(int numGraphNodes) {
        if (iNumGraphNodes > 1000) {
            iNumGraphNodes = numGraphNodes;
        }
    }

    public static void setDefaultNumberOfEdges(int numEdges) {
        GraphNode.setDefaultNumberOfEdges(numEdges);
    }

    public void addNode(String strGraphNodeName) {
        if (!this.nodeExists(strGraphNodeName)) {
            this.mapGraphNodes.put(strGraphNodeName, new GraphNode(strGraphNodeName));
        }
    }

    public void addNode(GraphNode node) {
        String strGraphNodeName = node.getName();
        if (!this.nodeExists(strGraphNodeName)) {
            float weight;
            String strGraphNodeTmp;
            this.mapGraphNodes.put(strGraphNodeName.intern(), node);
            Iterator it = node.getInlinks();
            while (it.hasNext()) {
                strGraphNodeTmp = (String)it.next();
                weight = node.getInlinkWeight(strGraphNodeTmp);
                this.addDirectedEdge(strGraphNodeTmp, strGraphNodeName);
            }
            it = node.getOutlinks();
            while (it.hasNext()) {
                strGraphNodeTmp = (String)it.next();
                weight = node.getOutlinkWeight(strGraphNodeTmp);
                this.addDirectedEdge(strGraphNodeName, strGraphNodeTmp);
            }
        }
    }

    public void removeNode(String strGraphNodeName) {
        GraphNode node = (GraphNode)this.mapGraphNodes.remove(strGraphNodeName);
        if (node != null) {
            GraphNode nodeTemp;
            Iterator it = node.getInlinks();
            while (it.hasNext()) {
                nodeTemp = this.getNode((String)it.next());
                nodeTemp.removeOutlink(strGraphNodeName);
            }
            it = node.getOutlinks();
            while (it.hasNext()) {
                nodeTemp = this.getNode((String)it.next());
                nodeTemp.removeInlink(strGraphNodeName);
            }
        }
    }

    public void removeNode(GraphNode node) {
        this.removeNode(node.getName());
    }

    public void addDirectedEdge(GraphEdge edge) {
        this.addDirectedEdge(edge.getSourceNode(), edge.getDestNode(), edge.getWeight());
    }

    public void addDirectedEdge(String strGraphNodeFrom, String strGraphNodeTo, float weight) {
        GraphNode graphNodeFrom = this.getOrMakeGraphNode(strGraphNodeFrom);
        GraphNode graphNodeTo = this.getOrMakeGraphNode(strGraphNodeTo);
        graphNodeFrom.addOutlink(strGraphNodeTo, weight);
        graphNodeTo.addInlink(strGraphNodeFrom, -weight);
    }

    public void addDirectedEdge(String strGraphNodeFrom, String strGraphNodeTo) {
        this.addDirectedEdge(strGraphNodeFrom, strGraphNodeTo, 1.0f);
    }

    public void addDirectedEdge(GraphNode graphNodeFrom, GraphNode graphNodeTo) {
        this.addDirectedEdge(graphNodeFrom.getName(), graphNodeTo.getName());
    }

    public void addDirectedEdge(GraphNode graphNodeFrom, GraphNode graphNodeTo, float weight) {
        this.addDirectedEdge(graphNodeFrom.getName(), graphNodeTo.getName(), weight);
    }

    public void addUndirectedEdge(GraphEdge edge) {
        this.addUndirectedEdge(edge.getSourceNode(), edge.getDestNode(), edge.getWeight());
    }

    public void addUndirectedEdge(String strGraphNodeFrom, String strGraphNodeTo, float weight) {
        this.addDirectedEdge(strGraphNodeFrom, strGraphNodeTo, weight);
        this.addDirectedEdge(strGraphNodeTo, strGraphNodeFrom, weight);
    }

    public void addUndirectedEdge(String strGraphNodeFrom, String strGraphNodeTo) {
        this.addDirectedEdge(strGraphNodeFrom, strGraphNodeTo);
        this.addDirectedEdge(strGraphNodeTo, strGraphNodeFrom);
    }

    public void addUndirectedEdge(GraphNode graphNodeFrom, GraphNode graphNodeTo) {
        this.addDirectedEdge(graphNodeFrom, graphNodeTo);
        this.addDirectedEdge(graphNodeTo, graphNodeFrom);
    }

    public void addUndirectedEdge(GraphNode graphNodeFrom, GraphNode graphNodeTo, float weight) {
        this.addDirectedEdge(graphNodeFrom, graphNodeTo, weight);
        this.addDirectedEdge(graphNodeTo, graphNodeFrom, weight);
    }

    public void removeDirectedEdge(String strGraphNodeFrom, String strGraphNodeTo) {
        GraphNode graphNodeFrom = this.getNode(strGraphNodeFrom);
        GraphNode graphNodeTo = this.getNode(strGraphNodeTo);
        if (graphNodeFrom != null) {
            graphNodeFrom.removeOutlink(strGraphNodeTo);
        }
        if (graphNodeTo != null) {
            graphNodeTo.removeInlink(strGraphNodeFrom);
        }
    }

    public void removeDirectedEdge(GraphNode graphNodeFrom, GraphNode graphNodeTo) {
        this.removeDirectedEdge(graphNodeFrom.getName(), graphNodeTo.getName());
    }

    public void removeUndirectedEdge(String strGraphNodeFrom, String strGraphNodeTo) {
        this.removeDirectedEdge(strGraphNodeFrom, strGraphNodeTo);
        this.removeDirectedEdge(strGraphNodeTo, strGraphNodeFrom);
    }

    public void removeUndirectedEdge(GraphNode graphNodeFrom, GraphNode graphNodeTo) {
        this.removeDirectedEdge(graphNodeFrom, graphNodeTo);
        this.removeDirectedEdge(graphNodeTo, graphNodeFrom);
    }

    public GraphNode getNode(String strGraphNodeName) {
        return (GraphNode)this.mapGraphNodes.get(strGraphNodeName);
    }

    public boolean nodeExists(String strGraphNodeName) {
        return this.mapGraphNodes.get(strGraphNodeName) != null;
    }

    public boolean nodeExists(GraphNode node) {
        return this.nodeExists(node.getName());
    }

    public boolean isAdjacent(String strGraphNodeFrom, String strGraphNodeTo) {
        GraphNode GraphNode2 = this.getNode(strGraphNodeFrom);
        if (GraphNode2 != null) {
            return GraphNode2.hasOutlinkTo(strGraphNodeTo);
        }
        return false;
    }

    public boolean isAdjacent(GraphNode graphNodeFrom, GraphNode graphNodeTo) {
        return graphNodeFrom.hasOutlinkTo(graphNodeTo.getName());
    }

    public float getWeight(String strGraphNodeFrom, String strGraphNodeTo) {
        GraphNode node = this.getNode(strGraphNodeFrom);
        if (node != null) {
            return node.getOutlinkWeight(strGraphNodeTo);
        }
        return Float.NaN;
    }

    public float getWeight(GraphNode graphNodeFrom, GraphNode graphNodeTo) {
        return graphNodeFrom.getOutlinkWeight(graphNodeTo.getName());
    }

    public int numberOfGraphNodes() {
        return this.mapGraphNodes.size();
    }

    public int numberOfEdges() {
        int iNumEdges = 0;
        Iterator it = this.mapGraphNodes.values().iterator();
        while (it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            iNumEdges += node.getOutDegree();
        }
        return iNumEdges;
    }

    private GraphNode getOrMakeGraphNode(String strGraphNodeName) {
        GraphNode node = (GraphNode)this.mapGraphNodes.get(strGraphNodeName);
        if (node == null) {
            node = new GraphNode(strGraphNodeName);
            this.mapGraphNodes.put(strGraphNodeName.intern(), node);
        }
        return node;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator<Object> it = this.mapGraphNodes.values().iterator();
        LinkedList<GraphEdge> listEdges = new LinkedList<GraphEdge>();
        strbuf.append("NODES\n");
        while (it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            strbuf.append(node.getName());
            strbuf.append("\n");
            Iterator itOut = node.getOutlinks();
            while (itOut.hasNext()) {
                String strSrc = node.getName();
                String strDst = (String)itOut.next();
                listEdges.add(new GraphEdge(strSrc, strDst, node.getOutlinkWeight(strDst)));
            }
        }
        strbuf.append("EDGES\n");
        it = listEdges.iterator();
        while (it.hasNext()) {
            strbuf.append(it.next());
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    public String toDebugString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.mapGraphNodes.values().iterator();
        while (it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            strbuf.append(node);
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    public static Graph getTestInstanceAAA() {
        Graph g = new Graph();
        g.addNode("GraphNode1");
        g.addNode("GraphNode2");
        g.addNode("GraphNode3");
        return g;
    }

    public static Graph getTestInstanceBBB() {
        Graph g = new Graph();
        g.addNode("GraphNode1");
        g.addNode("GraphNode2");
        g.addNode("GraphNode3");
        g.addDirectedEdge("GraphNode1", "GraphNode3");
        g.addDirectedEdge("GraphNode3", "GraphNode2");
        return g;
    }

    public static Graph getTestInstanceCCC() {
        Graph graph = new Graph();
        graph.addDirectedEdge("A", "B", 1.0f);
        graph.addDirectedEdge("A", "C", 2.0f);
        graph.addDirectedEdge("A", "D", 3.0f);
        graph.addDirectedEdge("A", "E", 4.0f);
        graph.addDirectedEdge("A", "F", 5.0f);
        graph.addDirectedEdge("B", "BA", 6.0f);
        graph.addDirectedEdge("B", "BB", 7.0f);
        graph.addDirectedEdge("B", "BC", 8.0f);
        graph.addDirectedEdge("C", "B");
        graph.addDirectedEdge("C", "D");
        graph.addDirectedEdge("E", "EA", 9.0f);
        graph.addDirectedEdge("E", "EB", 10.0f);
        graph.addDirectedEdge("E", "EC", 11.0f);
        graph.addDirectedEdge("F", "FA", 12.0f);
        graph.addDirectedEdge("F", "FB", 13.0f);
        graph.addDirectedEdge("D", "BC", 14.0f);
        graph.addDirectedEdge("D", "EA", 15.0f);
        graph.addDirectedEdge("BC", "EA", 16.0f);
        graph.addDirectedEdge("BC", "C");
        graph.addDirectedEdge("BB", "H");
        graph.addDirectedEdge("BC", "H");
        graph.addDirectedEdge("EA", "H");
        graph.addDirectedEdge("FA", "G");
        graph.addDirectedEdge("FA", "E");
        graph.addDirectedEdge("FB", "G");
        graph.addDirectedEdge("FB", "B");
        graph.addDirectedEdge("FB", "I");
        graph.addDirectedEdge("G", "H");
        graph.addDirectedEdge("G", "I");
        graph.addDirectedEdge("BA", "FB");
        graph.addDirectedEdge("BB", "H");
        graph.addDirectedEdge("EC", "FA");
        graph.addDirectedEdge("FA", "EC");
        graph.addDirectedEdge("H", "BA");
        graph.addDirectedEdge("H", "EA");
        return graph;
    }

    public static Graph getTestInstanceDDD() {
        Graph g = new Graph();
        g.addNode("GraphNode1");
        g.addNode("GraphNode2");
        g.addNode("GraphNode3");
        GraphNode node = new GraphNode("GraphNode4");
        node.addOutlink("GraphNode5");
        node.addOutlink("GraphNode6");
        g.addNode(node);
        return g;
    }

    private static void runTestAAA() {
        Graph g = Graph.getTestInstanceAAA();
        System.out.println(g);
        System.out.println();
        g = Graph.getTestInstanceBBB();
        System.out.println(g);
        System.out.println();
        g = Graph.getTestInstanceCCC();
        System.out.println(g);
        System.out.println();
        g = Graph.getTestInstanceDDD();
        System.out.println(g);
        System.out.println();
    }

    private static void runTestBBB() {
        Graph g = Graph.getTestInstanceCCC();
        Graph.search(g, "A", "BA");
        Graph.search(g, "A", "FB");
        Graph.search(g, "A", "H");
        Graph.search(g, "A", "G");
        Graph.search(g, "A", "I");
    }

    private static void runTestCCC() throws Exception {
        Graph.printAndParseGraph(Graph.getTestInstanceAAA());
        Graph.printAndParseGraph(Graph.getTestInstanceBBB());
        Graph.printAndParseGraph(Graph.getTestInstanceCCC());
        Graph.printAndParseGraph(Graph.getTestInstanceDDD());
    }

    private static void runTestDDD() throws Exception {
        FileReader frdr = new FileReader("map-parc-2.txt");
        Graph g = PARSER.parse(frdr);
        System.out.println("---------");
        System.out.println(g);
        System.out.println("---------");
        System.out.println(g.toDebugString());
        System.out.println("---------");
        Graph.search(g, "2230", "2236");
        System.out.println("---------");
        Graph.search(g, "CSLCommons", "2236");
        System.out.println("---------");
        Graph.search(g, "2168", "2230");
        System.out.println("---------");
        Graph.search(g, "2146", "2238");
        System.out.println("---------");
        Graph.search(g, "2160", "2121");
        System.out.println("---------");
        Graph.search(g, "2230", "2121");
        System.out.println("---------");
        Graph.search(g, "2230", "2146");
    }

    private static void runTestEEE() throws Exception {
        FileReader frdr = new FileReader("map-soda.txt");
        Graph g = PARSER.parse(frdr);
        System.out.println("---------");
        System.out.println(g);
        System.out.println("---------");
        System.out.println(g.toDebugString());
        System.out.println("**********************");
        Graph.search(g, "525", "306");
        System.out.println("**********************");
        Graph.search(g, "525", "527");
        System.out.println("**********************");
        Graph.search(g, "525", "510");
        System.out.println("**********************");
        Graph.search(g, "525", "683");
        System.out.println("**********************");
        Graph.search(g, "525", "606");
    }

    private static void printAndParseGraph(Graph g) throws Exception {
        System.out.println("--- before -----");
        System.out.println(g.toDebugString());
        System.out.println("--- parsed -----");
        Graph g2 = PARSER.parse(new StringReader(g.toString()));
        System.out.println(g2.toDebugString());
    }

    private static void search(Graph g, String strFrom, String strTo) {
        System.out.println("From " + strFrom + " to " + strTo);
        System.out.println("BidirBlind");
        long startTime = System.currentTimeMillis();
        System.out.println(Graph.searchBidirBlind(g, strFrom, strTo));
        long endTime = System.currentTimeMillis();
        System.out.println(endTime - startTime);
        System.out.println();
        System.out.println("------------------------------");
    }

    private static GraphPath searchDepthFirst(Graph g, String strFrom, String strTo) {
        return new GraphSearchDepthFirst().search(g, strFrom, strTo);
    }

    private static GraphPath searchBreadthFirst(Graph g, String strFrom, String strTo) {
        return new GraphSearchBreadthFirst().search(g, strFrom, strTo);
    }

    private static GraphPath searchBidirBlind(Graph g, String strFrom, String strTo) {
        return new GraphSearchBidirBlind().search(g, strFrom, strTo);
    }

    public static void main(String[] argv) throws Exception {
        Graph.runTestEEE();
    }
}

