/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.fsa;

import edu.berkeley.guir.lib.collection.fsa.Action;
import edu.berkeley.guir.lib.collection.fsa.FiniteStateAutomata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

class State {
    public static final String ALL_TRANSITION = "all-input";
    public static final String DEFAULT_TRANSITION = "unknown-input";
    public static final String TIMEOUT_TRANSITION = "timeout-input";
    private static final boolean DEBUG = true;
    FiniteStateAutomata fsa;
    String strName = "unnamed";
    int timeout = Integer.MAX_VALUE;
    Map mapTransitions = new HashMap();
    Map mapOnEnterActions = new HashMap();
    Map mapOnExitActions = new HashMap();
    Action timeoutAction = Action.EMPTY;

    public State(String newName) {
        this.strName = newName;
        this.commonInit();
    }

    public State(String newName, int millis) {
        this.strName = newName;
        this.timeout = millis;
        this.commonInit();
    }

    private void commonInit() {
        this.mapTransitions.put(DEFAULT_TRANSITION, this.strName);
        this.mapTransitions.put(TIMEOUT_TRANSITION, this.strName);
    }

    public String getName() {
        return this.strName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int millis) {
        this.timeout = millis;
    }

    public FiniteStateAutomata getFiniteStateAutomata() {
        return this.fsa;
    }

    public void setFiniteStateAutomata(FiniteStateAutomata newFsa) {
        this.fsa = newFsa;
    }

    public void addTransition(String strInput, String strNextState) {
        this.mapTransitions.put(strInput, strNextState);
    }

    public void setDefaultTransition(String strNextState) {
        this.mapTransitions.put(DEFAULT_TRANSITION, strNextState);
    }

    public void setTimeoutTransition(String strNextState) {
        this.mapTransitions.put(TIMEOUT_TRANSITION, strNextState);
    }

    public void setTimeoutTransition(String strNextState, int millis) {
        this.setTimeout(millis);
        this.setTimeoutTransition(strNextState);
    }

    public String getTransition(String strInput) {
        String strNextState = (String)this.mapTransitions.get(strInput);
        if (strNextState == null) {
            strNextState = this.getDefaultTransition();
        }
        return strNextState;
    }

    public String getDefaultTransition() {
        return (String)this.mapTransitions.get(DEFAULT_TRANSITION);
    }

    public String getTimeoutTransition() {
        return (String)this.mapTransitions.get(TIMEOUT_TRANSITION);
    }

    public void handleInput(String strInput) {
        String strNextState = this.getTransition(strInput);
        this.getFiniteStateAutomata().setCurrentState(strNextState);
    }

    public void addOnEnterAction(String strPrevState, Action action) {
        this.mapOnEnterActions.put(strPrevState, action);
    }

    public void addOnEnterDefaultAction(Action action) {
        this.mapOnEnterActions.put(ALL_TRANSITION, action);
    }

    public Action getOnEnterAction(String strPrevState) {
        Action action = (Action)this.mapOnEnterActions.get(strPrevState);
        if (action == null) {
            action = (Action)this.mapOnEnterActions.get(ALL_TRANSITION);
        }
        if (action == null) {
            action = Action.EMPTY;
        }
        return action;
    }

    public void addOnExitAction(String strPrevState, Action action) {
        this.mapOnExitActions.put(strPrevState, action);
    }

    public void addOnExitDefaultAction(Action action) {
        this.mapOnExitActions.put(ALL_TRANSITION, action);
    }

    public Action getOnExitAction(String strPrevState) {
        Action action = (Action)this.mapOnExitActions.get(strPrevState);
        if (action == null) {
            action = (Action)this.mapOnExitActions.get(ALL_TRANSITION);
        }
        if (action == null) {
            action = Action.EMPTY;
        }
        return action;
    }

    public void addTimeoutAction(Action action) {
        this.timeoutAction = action;
    }

    public Action getTimeoutAction() {
        return this.timeoutAction;
    }

    public String toString() {
        String strState;
        String strInput;
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("name: " + this.getName());
        if (this.getTimeout() != Integer.MAX_VALUE) {
            strbuf.append("\ntimeout: " + this.getTimeout());
        }
        strbuf.append("\ntransitions (input -> next-state):");
        LinkedList listKeys = new LinkedList(this.mapTransitions.keySet());
        listKeys.remove(ALL_TRANSITION);
        listKeys.remove(DEFAULT_TRANSITION);
        listKeys.remove(TIMEOUT_TRANSITION);
        Iterator it = listKeys.iterator();
        while (it.hasNext()) {
            strInput = (String)it.next();
            strbuf.append("\n");
            strbuf.append(this.toString(strInput));
        }
        strInput = TIMEOUT_TRANSITION;
        if (this.mapTransitions.get(strInput) != null) {
            strbuf.append("\n");
            strbuf.append(this.toString(strInput));
        }
        if (this.mapTransitions.get(strInput = DEFAULT_TRANSITION) != null) {
            strbuf.append("\n");
            strbuf.append(this.toString(strInput));
        }
        listKeys = new LinkedList(this.mapOnEnterActions.keySet());
        listKeys.remove(ALL_TRANSITION);
        it = listKeys.iterator();
        strbuf.append("\nonEnter() (state -> action)");
        while (it.hasNext()) {
            strbuf.append("\n   ");
            strState = (String)it.next();
            strbuf.append(strState);
            strbuf.append(" -> ");
            strbuf.append(this.mapOnEnterActions.get(strState));
        }
        strState = ALL_TRANSITION;
        if (this.mapOnEnterActions.get(strState) != null) {
            strbuf.append("\n   ");
            strbuf.append(strState);
            strbuf.append(" -> ");
            strbuf.append(this.mapOnEnterActions.get(strState));
        }
        listKeys = new LinkedList(this.mapOnExitActions.keySet());
        listKeys.remove(ALL_TRANSITION);
        it = listKeys.iterator();
        strbuf.append("\nonExit() (state -> action)");
        while (it.hasNext()) {
            strbuf.append("\n   ");
            strState = (String)it.next();
            strbuf.append(strState);
            strbuf.append(" -> ");
            strbuf.append(this.mapOnExitActions.get(strState));
        }
        strState = ALL_TRANSITION;
        if (this.mapOnExitActions.get(strState) != null) {
            strbuf.append("\n   ");
            strbuf.append(strState);
            strbuf.append(" -> ");
            strbuf.append(this.mapOnExitActions.get(strState));
        }
        return strbuf.toString();
    }

    protected String toString(String strInput) {
        String strNextState = (String)this.mapTransitions.get(strInput);
        Action action = this.getOnExitAction(strNextState);
        String strAction = action == null ? "" : " (Action: " + action.getName() + ")";
        return "   " + strInput + " -> " + strNextState + strAction;
    }

    public static void main(String[] argv) throws Exception {
    }
}

