/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.fsa;

import edu.berkeley.guir.lib.collection.fsa.Action;
import edu.berkeley.guir.lib.collection.fsa.State;
import edu.berkeley.guir.lib.collection.fsa.StateTransitionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FiniteStateAutomata {
    private static final boolean DEBUG = false;
    public static final String INITIAL_STATE = "<start>";
    Object monitor = new Object();
    Map mapStates = new LinkedHashMap();
    TimeoutThread t = new TimeoutThread();
    State startState;
    State currentState;
    List listListeners = new LinkedList();
    String strLastInput;
    boolean flagContinue = true;

    public FiniteStateAutomata() {
        this.t.start();
        this.addStateTransitionListener(new ActionListener());
    }

    public void addStateTransitionListener(StateTransitionListener l) {
        this.listListeners.add(l);
    }

    public void removeStateTransitionListener(StateTransitionListener l) {
        this.listListeners.remove(l);
    }

    public void clearStateTransitionListeners() {
        this.listListeners.clear();
    }

    protected void fireOnEnter(String strFrom, String strCurrent) {
        Iterator it = this.listListeners.iterator();
        while (it.hasNext()) {
            StateTransitionListener lstnr = (StateTransitionListener)it.next();
            lstnr.onEnterState(this, strFrom, strCurrent);
        }
    }

    protected void fireOnExit(String strCurrent, String strTo) {
        Iterator it = this.listListeners.iterator();
        while (it.hasNext()) {
            StateTransitionListener lstnr = (StateTransitionListener)it.next();
            lstnr.onExitState(this, strCurrent, strTo);
        }
    }

    protected State getState(String strStateName) {
        return (State)this.mapStates.get(strStateName);
    }

    protected State getOrCreateState(String strStateName) {
        State s = this.getState(strStateName);
        if (s == null) {
            s = new State(strStateName);
            this.mapStates.put(strStateName, s);
            s.setFiniteStateAutomata(this);
        }
        return s;
    }

    public void setStartState(String str) {
        this.startState = this.getOrCreateState(str);
    }

    protected State getStartState() {
        return this.startState;
    }

    public void addState(String strStateAA) {
        State sAA = this.getOrCreateState(strStateAA);
    }

    public void addTransition(String strStateAA, String strStateBB, String strInput) {
        State sAA = this.getOrCreateState(strStateAA);
        State sBB = this.getOrCreateState(strStateBB);
        sAA.addTransition(strInput, strStateBB);
    }

    public void addTransition(String strStateAA, String strStateBB, String strInput, Action action) {
        this.addTransition(strStateAA, strStateBB, strInput);
        this.addOnExitAction(strStateAA, strStateBB, action);
    }

    public void addTimeoutTransition(String strStateAA, String strStateBB, int millis) {
        State sAA = this.getOrCreateState(strStateAA);
        State sBB = this.getOrCreateState(strStateBB);
        sAA.setTimeoutTransition(strStateBB, millis);
    }

    public void addDefaultTransition(String strStateAA, String strStateBB) {
        State sAA = this.getOrCreateState(strStateAA);
        State sBB = this.getOrCreateState(strStateBB);
        sAA.setDefaultTransition(strStateBB);
    }

    public void addTimeoutAction(String strState, Action action) {
        State sAA = this.getOrCreateState(strState);
        sAA.addTimeoutAction(action);
    }

    public void addOnEnterAction(String strFrom, String strEnterInto, Action action) {
        State sEnterInto = this.getOrCreateState(strEnterInto);
        sEnterInto.addOnEnterAction(strFrom, action);
    }

    public void addOnEnterDefaultAction(String strStateAA, Action action) {
        State sAA = this.getOrCreateState(strStateAA);
        sAA.addOnEnterDefaultAction(action);
    }

    public void addOnExitAction(String strExitFrom, String strTo, Action action) {
        State sExitFrom = this.getOrCreateState(strExitFrom);
        sExitFrom.addOnExitAction(strTo, action);
    }

    public void addOnExitDefaultAction(String strStateAA, Action action) {
        State sAA = this.getOrCreateState(strStateAA);
        sAA.addOnExitDefaultAction(action);
    }

    public void setCurrentState(String strNextState) {
        this.t.cancel();
        if (!this.flagContinue) {
            return;
        }
        State lastState = this.currentState;
        State nextState = this.getState(strNextState);
        String strLastState = lastState == null ? null : lastState.getName();
        if (nextState == null) {
            throw new IllegalArgumentException("Cannot transition to: " + strNextState);
        }
        if (strLastState != null && strNextState != null) {
            this.fireOnExit(strLastState, strNextState);
        }
        this.currentState = nextState;
        if (strLastState != null) {
            this.fireOnEnter(strLastState, this.currentState.getName());
        }
        this.t.setTimeout(this.currentState.getTimeout());
    }

    protected State getCurrentState() {
        if (this.currentState == null) {
            this.reset();
        }
        return this.currentState;
    }

    protected void onTimeout() {
        if (!this.flagContinue) {
            return;
        }
        Action action = this.currentState.getTimeoutAction();
        action.doAction(this);
        this.setCurrentState(this.currentState.getTimeoutTransition());
    }

    public void startAutomata() {
        this.reset();
    }

    public void reset() {
        this.flagContinue = true;
        if (!this.t.isAlive()) {
            this.t.start();
        }
        this.setCurrentState(this.startState.getName());
    }

    public void stop() {
        this.flagContinue = false;
        this.t.cancel();
    }

    public void handleInput(String strInput) {
        if (this.startState == null) {
            throw new IllegalStateException("Start state not specified");
        }
        this.strLastInput = strInput;
        this.getCurrentState().handleInput(strInput);
    }

    public String getLastInput() {
        return this.strLastInput;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.mapStates.keySet().iterator();
        strbuf.append("Start State: " + this.startState.getName() + "\n\n");
        while (it.hasNext()) {
            String strKey = (String)it.next();
            strbuf.append(this.mapStates.get(strKey).toString());
            strbuf.append("\n\n");
        }
        return strbuf.toString();
    }

    public static void testInteractive(FiniteStateAutomata fsa) throws IOException {
        String str;
        System.out.println(fsa);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        fsa.addStateTransitionListener(StateTransitionListener.CONSOLE);
        fsa.reset();
        while ((str = rdr.readLine()) != null) {
            fsa.handleInput(str);
            System.out.println();
        }
    }

    public static FiniteStateAutomata getTestInstanceAAA() {
        FiniteStateAutomata fsa = new FiniteStateAutomata();
        fsa.addTransition("A", "B", "1");
        fsa.addTransition("A", "C", "2");
        fsa.addTransition("A", "D", "3");
        fsa.addDefaultTransition("A", "D");
        fsa.addOnEnterAction("A", "B", new Action.Console("A", "B"));
        fsa.addOnEnterDefaultAction("B", new Action.Console("all", "B"));
        fsa.addTransition("B", "A", "A");
        fsa.addTransition("B", "C", "C");
        fsa.addTransition("B", "D", "D");
        fsa.addTimeoutTransition("B", "A", 5000);
        fsa.addTransition("C", "A", "A");
        fsa.addTransition("C", "B", "B");
        fsa.addTransition("C", "D", "D");
        fsa.addTransition("D", "A", "A");
        fsa.addTransition("D", "B", "B");
        fsa.addTransition("D", "C", "C");
        fsa.addTransition("E", "A", "1");
        fsa.addTransition("E", "A", "2");
        fsa.addTransition("E", "A", "3");
        fsa.setStartState("A");
        return fsa;
    }

    public static FiniteStateAutomata getTestInstanceBBB() {
        FiniteStateAutomata fsa = new FiniteStateAutomata();
        fsa.addState("start");
        fsa.setStartState("start");
        fsa.addTimeoutTransition("start", "RequestInitial", 1000);
        fsa.addOnEnterDefaultAction("RequestInitial", new Action.Console("SendInitialRequest"));
        fsa.addTransition("RequestInitial", "RequestPreference", "1");
        fsa.addTransition("RequestInitial", "RequestPreference", "2");
        fsa.addTransition("RequestInitial", "RequestPreference", "3");
        fsa.addTransition("RequestInitial", "RequestPreference", "4");
        fsa.addTransition("RequestInitial", "MoreInfo", "5");
        fsa.addOnEnterAction("RequestInitial", "RequestPreference", new Action.Console("SendPreferenceAction"));
        fsa.addOnEnterAction("RequestInitial", "MoreInfo", new Action.Console("SendMoreInfoAction"));
        fsa.addTimeoutTransition("RequestPreference", "ProcessPreference", 15000);
        return fsa;
    }

    private static void runTestAAA() throws Exception {
        FiniteStateAutomata.testInteractive(FiniteStateAutomata.getTestInstanceAAA());
    }

    public static void main(String[] argv) throws Exception {
        FiniteStateAutomata.testInteractive(FiniteStateAutomata.getTestInstanceBBB());
    }

    class ActionListener
    implements StateTransitionListener {
        ActionListener() {
        }

        public void onEnterState(FiniteStateAutomata fsa, String strFrom, String strCurrent) {
            FiniteStateAutomata.this.getState(strCurrent).getOnEnterAction(strFrom).doAction(FiniteStateAutomata.this);
        }

        public void onExitState(FiniteStateAutomata fsa, String strCurrent, String strTo) {
            FiniteStateAutomata.this.getState(strCurrent).getOnExitAction(strTo).doAction(FiniteStateAutomata.this);
        }
    }

    class TimeoutThread
    extends Thread {
        long timeout = -1L;
        boolean flagExecute;

        TimeoutThread() {
        }

        public void setTimeout(long millis) {
            Object object = FiniteStateAutomata.this.monitor;
            synchronized (object) {
                FiniteStateAutomata.this.t.interrupt();
                this.flagExecute = true;
                this.timeout = millis;
            }
        }

        public void cancel() {
            this.flagExecute = false;
            FiniteStateAutomata.this.t.interrupt();
        }

        public void run() {
            while (FiniteStateAutomata.this.flagContinue) {
                this.flagExecute = true;
                Object object = FiniteStateAutomata.this.monitor;
                synchronized (object) {
                    try {
                        if (this.timeout < 0L) {
                            FiniteStateAutomata.this.monitor.wait();
                        } else {
                            FiniteStateAutomata.this.monitor.wait(this.timeout);
                            if (this.flagExecute) {
                                FiniteStateAutomata.this.onTimeout();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

