/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection.fsa;

import edu.berkeley.guir.lib.collection.fsa.FiniteStateAutomata;

public abstract class Action {
    public static Action EMPTY = new Empty();

    public abstract void doAction(FiniteStateAutomata var1);

    public String getName() {
        return this.getClass().getName();
    }

    public String toString() {
        return this.getName();
    }

    static class Empty
    extends Action {
        Empty() {
        }

        public String getName() {
            return "none";
        }

        public void doAction(FiniteStateAutomata fsa) {
        }
    }

    public static class Console
    extends Action {
        String strFrom;
        String strTo;
        String strMsg;

        public Console(String newMsg) {
            this.strMsg = newMsg;
        }

        public Console(String newFrom, String newTo) {
            this.strFrom = newFrom;
            this.strTo = newTo;
        }

        public String getName() {
            if (this.strMsg != null) {
                return "console: " + this.strMsg;
            }
            return "console";
        }

        public void doAction(FiniteStateAutomata fsa) {
            if (this.strFrom != null && this.strTo != null) {
                System.out.println("Action: from: " + this.strFrom + " to: " + this.strTo);
            } else if (this.strMsg != null) {
                System.out.println(this.strMsg);
            }
        }
    }
}

