/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    Map map = new WeakHashMap();

    public boolean add(Object obj) {
        return this.map.put(obj, Boolean.TRUE) == null;
    }

    public boolean remove(Object obj) {
        return this.map.remove(obj) == Boolean.TRUE;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public Object clone() {
        try {
            WeakHashSet s = (WeakHashSet)super.clone();
            s.map = new WeakHashMap();
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                s.add(it.next());
            }
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.map = new WeakHashMap();
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            Object e = s.readObject();
            this.map.put(e, Boolean.TRUE);
            ++i;
        }
    }
}

