/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.TimedEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TimedEventQueue {
    private static final boolean DEBUG = false;
    public static final DateFormat DATEFORMAT = new SimpleDateFormat("EEE yyyy.MMM.dd HH:mm:ss z");
    List listEvents = Collections.synchronizedList(new LinkedList());
    boolean flagContinue = true;
    Thread timedEventThread = new TimedEventThread();
    Object monitor = this;

    public TimedEventQueue() {
        this.timedEventThread.setDaemon(true);
        this.timedEventThread.start();
    }

    public void shutdown() {
        this.flagContinue = false;
        this.timedEventThread.interrupt();
    }

    private int findIndex(long millis) {
        Iterator it = this.listEvents.iterator();
        int index = 0;
        while (it.hasNext()) {
            TimedEvent tmpevt = (TimedEvent)it.next();
            if (millis < tmpevt.getActivationTime()) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public synchronized void enqueue(TimedEvent evt) {
        int index = this.findIndex(evt.getActivationTime());
        this.listEvents.add(index, evt);
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    public synchronized long getNextEventTime() {
        if (this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        TimedEvent evt = (TimedEvent)this.listEvents.get(0);
        return evt.getActivationTime();
    }

    public synchronized TimedEvent dequeue() {
        return (TimedEvent)this.listEvents.remove(0);
    }

    public synchronized List getAllEvents(long millis) {
        int index = this.findIndex(millis);
        LinkedList<TimedEvent> listBefore = new LinkedList<TimedEvent>();
        int i = 0;
        while (i < index) {
            listBefore.add(this.dequeue());
            ++i;
        }
        return listBefore;
    }

    public int size() {
        return this.listEvents.size();
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public synchronized String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.listEvents.iterator();
        strbuf.append("TimedEventQueue\n");
        while (it.hasNext()) {
            TimedEvent evt = (TimedEvent)it.next();
            long activationTime = evt.getActivationTime();
            Date d = new Date(activationTime);
            strbuf.append("   run: " + DATEFORMAT.format(d) + " " + evt.toString());
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    public static TimedEvent getTestTimedEvent() {
        TimedEvent.TestTimedEvent evt = new TimedEvent.TestTimedEvent();
        long curtime = System.currentTimeMillis();
        long acttime = (long)(60000.0 * Math.random());
        evt.setActivationTime(curtime + acttime);
        evt.setRecurring(10000);
        return evt;
    }

    private static void runTestAAA() throws Exception {
        TimedEventQueue q = new TimedEventQueue();
        System.out.println(q);
        Thread.sleep(2000L);
        int i = 0;
        while (i < 5) {
            TimedEvent evt = TimedEventQueue.getTestTimedEvent();
            System.out.println("adding " + evt);
            q.enqueue(evt);
            System.out.println(q);
            ++i;
        }
        q.enqueue(new TimedEvent.TestTimedEvent(0L));
    }

    public static void main(String[] argv) throws Exception {
        TimedEventQueue.runTestAAA();
    }

    class TimedEventThread
    extends Thread {
        public TimedEventThread() {
            super("TimedEventThread");
            this.setPriority(1);
        }

        public void executeEvents() {
            List listEvents = TimedEventQueue.this.getAllEvents(System.currentTimeMillis());
            Iterator it = listEvents.iterator();
            while (it.hasNext()) {
                TimedEvent evt = (TimedEvent)it.next();
                try {
                    evt.run();
                    if (!evt.isRecurring()) continue;
                    evt.updateActivationTime();
                    TimedEventQueue.this.enqueue(evt);
                }
                catch (Exception e) {
                    System.out.println("Ignoring error, continuing...");
                    e.printStackTrace();
                }
            }
        }

        private void doWait(long millis) {
            try {
                Object object = TimedEventQueue.this.monitor;
                synchronized (object) {
                    TimedEventQueue.this.monitor.wait(millis);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            while (TimedEventQueue.this.flagContinue) {
                if (TimedEventQueue.this.isEmpty()) {
                    this.doWait(0L);
                    continue;
                }
                Object object = TimedEventQueue.this.monitor;
                synchronized (object) {
                    long curTime = System.currentTimeMillis();
                    long nextTime = TimedEventQueue.this.getNextEventTime();
                    long sleepTime = nextTime - curTime;
                    if (sleepTime > 0L) {
                        this.doWait(sleepTime);
                    } else {
                        this.executeEvents();
                    }
                }
            }
        }
    }
}

