/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.util.Date;

public abstract class TimedEvent
implements Runnable {
    static int nextID = 0;
    long activationTime;
    int delay = -1;

    public TimedEvent() {
    }

    public TimedEvent(long millisAbsoluteTime) {
        this.setActivationTime(millisAbsoluteTime);
    }

    public TimedEvent(long millisAbsoluteTime, int delay) {
        this.setActivationTime(millisAbsoluteTime);
        this.setRecurring(delay);
    }

    public void setActivationTime(long millisAbsoluteTime) {
        this.activationTime = millisAbsoluteTime;
    }

    public long getActivationTime() {
        return this.activationTime;
    }

    public void setRecurring(int aDelayMillis) {
        this.delay = aDelayMillis;
    }

    public boolean isRecurring() {
        return this.delay > 0;
    }

    public void updateActivationTime() {
        if (!this.isRecurring()) {
            return;
        }
        this.setActivationTime(System.currentTimeMillis() + (long)this.delay);
    }

    public String toString() {
        String strClassName = this.getClass().getName();
        int index = strClassName.lastIndexOf(".");
        strClassName = strClassName.substring(index + 1);
        return String.valueOf(strClassName) + " ActivationTime: " + new Date(this.activationTime);
    }

    public static class TestTimedEvent
    extends TimedEvent {
        int id = nextID++;

        public TestTimedEvent() {
        }

        public TestTimedEvent(long millis) {
            this.setActivationTime(millis);
        }

        public void run() {
            long curTime = System.currentTimeMillis();
            System.out.println(String.valueOf(curTime) + " running " + this.toString());
        }

        public String toString() {
            return "id: " + this.id;
        }
    }
}

