/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.NumericalComparator;
import edu.berkeley.guir.lib.collection.SortedValueMap;

public class SortedValueNumMap
extends SortedValueMap {
    private static double COMPARISON_THRESHOLD = 0.001953125;
    private double threshold = Double.MAX_VALUE;
    private boolean flagUseThreshold = false;
    private double sumThreshold = Double.MAX_VALUE;
    private boolean flagUseSumThreshold = false;
    private static boolean default_flagAscending = true;
    private static double default_threshold = Double.MAX_VALUE;
    private static boolean default_flagUseThreshold = false;
    private static double default_sumThreshold = Double.MAX_VALUE;
    private static boolean default_flagUseSumThreshold = false;
    double sumVals = 0.0;

    public void setAscending(boolean flag) {
        super.setAscending(flag);
    }

    public void setThreshold(double d) {
        this.flagUseThreshold = true;
        this.threshold = d;
    }

    public void setUseThreshold(boolean flag) {
        this.flagUseThreshold = flag;
    }

    public void setSumThreshold(double d) {
        this.flagUseSumThreshold = true;
        this.sumThreshold = d;
    }

    public void setUseSumThreshold(boolean flag) {
        this.flagUseSumThreshold = flag;
    }

    public static void setDefaultAscending(boolean flag) {
        default_flagAscending = flag;
    }

    public static void setDefaultThreshold(double d) {
        default_threshold = d;
    }

    public static void setDefaultUseThreshold(boolean flag) {
        default_flagUseThreshold = flag;
    }

    public static void setDefaultSumThreshold(double d) {
        default_sumThreshold = d;
    }

    public static void setDefaultUseSumThreshold(boolean flag) {
        default_flagUseSumThreshold = flag;
    }

    public SortedValueNumMap() {
        super(new NumericalComparator());
        this.threshold = default_threshold;
        this.flagUseThreshold = default_flagUseThreshold;
        this.sumThreshold = default_sumThreshold;
        this.flagUseSumThreshold = default_flagUseSumThreshold;
    }

    public void put(Object key, int num) {
        this.put(key, new Double(num));
    }

    public void put(Object key, float num) {
        this.put(key, new Double(num));
    }

    public void put(Object key, double num) {
        this.put(key, new Double(num));
    }

    public void put(Object key, Number num) {
        double value = num.doubleValue();
        if (this.flagUseThreshold && value > this.threshold + COMPARISON_THRESHOLD) {
            throw new NumberFormatException("Value " + value + " cannot exceed threshold value " + this.threshold);
        }
        if (this.flagUseSumThreshold && value + this.sumVals > this.sumThreshold + COMPARISON_THRESHOLD) {
            double val = value + this.sumVals;
            throw new NumberFormatException("Sum of values " + val + " cannot exceed sum threshold value " + this.sumThreshold);
        }
        this.sumVals += value;
        super.put(key, num);
    }

    public static void main(String[] argv) {
        SortedValueNumMap c = new SortedValueNumMap();
        c.setAscending(false);
        c.put((Object)"lemur", new Float(0.1f));
        System.out.println(c);
        c.put((Object)"wallaby", new Float(0.09f));
        System.out.println(c);
        c.put((Object)"wallaby", new Float(0.08f));
        System.out.println(c);
        c.put((Object)"kiwi", new Float(0.07f));
        c.put((Object)"mandrill", new Float(0.06f));
        System.out.println(c);
        c.put((Object)"emu", new Float(0.05f));
        System.out.println(c);
        c.put((Object)"exceedval", new Float(1.05f));
        System.out.println(c);
        c.put((Object)"exceedsum", new Float(0.05f));
        System.out.println(c);
        c.remove("kiwi");
        System.out.println(c);
    }
}

