/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.NumericalComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SortedValueMap {
    private boolean flagAscending = true;
    private static boolean default_flagAscending = true;
    Map table;
    List list;
    boolean flagDirty = false;
    Comparator comp;
    Comparator internalComp = new InternalComparator();

    public void setAscending(boolean flag) {
        this.flagAscending = flag;
    }

    public static void setDefaultAscending(boolean flag) {
        default_flagAscending = flag;
    }

    public SortedValueMap(Comparator newComp) {
        this.table = new HashMap();
        this.comp = newComp;
    }

    private void updateList() {
        if (this.flagDirty) {
            this.list = new LinkedList(this.table.entrySet());
            Collections.sort(this.list, this.internalComp);
            this.flagDirty = false;
        }
    }

    public void clear() {
        this.flagDirty = true;
        this.table.clear();
    }

    public boolean containsKey(Object key) {
        return this.table.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.table.containsValue(value);
    }

    public Set entrySet() {
        return this.table.entrySet();
    }

    public boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }

    public Object get(Object obj) {
        return this.table.get(obj);
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Set keySet() {
        return this.table.keySet();
    }

    public Object put(Object key, Object value) {
        this.flagDirty = true;
        return this.table.put(key, value);
    }

    public void putAll(Map newMap) {
        Iterator it = newMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, newMap.get(key));
        }
    }

    public Object remove(Object key) {
        this.flagDirty = true;
        return this.table.remove(key);
    }

    public int size() {
        return this.table.size();
    }

    public Collection values() {
        return this.table.values();
    }

    public Object getFirstKey() {
        this.updateList();
        if (this.list.size() > 0) {
            Map.Entry m = (Map.Entry)this.list.get(0);
            return m.getKey();
        }
        return null;
    }

    public Object getLastKey() {
        this.updateList();
        if (this.list.size() > 0) {
            Map.Entry m = (Map.Entry)this.list.get(this.list.size() - 1);
            return m.getKey();
        }
        return null;
    }

    public Object getFirstValue() {
        return this.get(this.getFirstKey());
    }

    public Object getLastValue() {
        return this.get(this.getLastKey());
    }

    public Object getLargestKey() {
        if (this.flagAscending) {
            return this.getLastKey();
        }
        return this.getFirstKey();
    }

    public Object getSmallestKey() {
        if (this.flagAscending) {
            return this.getFirstKey();
        }
        return this.getLastKey();
    }

    public Object getLargestValue() {
        if (this.flagAscending) {
            return this.getLastValue();
        }
        return this.getFirstValue();
    }

    public Object getSmallestValue() {
        if (this.flagAscending) {
            return this.getFirstValue();
        }
        return this.getLastValue();
    }

    public String toString() {
        this.updateList();
        return this.list.toString();
    }

    public static void main(String[] argv) {
        SortedValueMap c = new SortedValueMap(new NumericalComparator());
        c.setAscending(false);
        c.put("lemur", new Float(0.11f));
        c.put("wallaby", new Float(0.11f));
        System.out.println(c);
        c.put("kiwi", new Float(0.11f));
        c.put("mandrill", new Float(0.11f));
        System.out.println(c);
        c.put("emu", new Float(0.11f));
        System.out.println(c);
        c.put("exceedsum", new Float(0.55f));
        System.out.println(c);
        c.put("exceedval", new Float(1.05f));
        System.out.println(c);
        System.out.println(c.getFirstKey());
        System.out.println(c.getFirstValue());
        System.out.println(c.getLastKey());
        System.out.println(c.getLastValue());
        System.out.println(c.getSmallestKey());
        System.out.println(c.getSmallestValue());
        System.out.println(c.getLargestKey());
        System.out.println(c.getLargestValue());
        System.out.println();
        System.out.println(c.get("exceedsum"));
    }

    class InternalComparator
    implements Comparator {
        InternalComparator() {
        }

        public int compare(Object key1, Object key2) {
            Map.Entry m1 = (Map.Entry)key1;
            Map.Entry m2 = (Map.Entry)key2;
            int returnVal = SortedValueMap.this.comp.compare(m1.getValue(), m2.getValue());
            if (returnVal == 0) {
                returnVal = m1.getKey().hashCode() > m2.getKey().hashCode() ? 1 : -1;
            }
            if (SortedValueMap.this.flagAscending) {
                return returnVal;
            }
            return -1 * returnVal;
        }
    }
}

