/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Queue {
    private static int defaultMaxLen = 10;
    private static boolean defaultFlagResizable = true;
    List listElements = new LinkedList();
    int maxlen = defaultMaxLen;
    boolean flagResizable = defaultFlagResizable;

    public static void setDefaultMaxLen(int newMaxLen) {
        defaultMaxLen = newMaxLen;
    }

    public static void setDefaultResizable(boolean flag) {
        defaultFlagResizable = flag;
    }

    public Queue() {
    }

    public Queue(int newMaxLen) {
        this.maxlen = newMaxLen;
        this.flagResizable = false;
    }

    public boolean isResizable() {
        return this.flagResizable;
    }

    public boolean isFixed() {
        return !this.flagResizable;
    }

    public void setMaxLen(int newMaxLen) {
        if (this.isFixed()) {
            this.maxlen = newMaxLen;
        }
    }

    public int getMaxLen() {
        if (this.isFixed()) {
            return this.maxlen;
        }
        return Integer.MAX_VALUE;
    }

    public int size() {
        return this.listElements.size();
    }

    public void clear() {
        this.listElements.clear();
    }

    public void enqueue(Object obj) {
        if (this.isFull()) {
            throw new FullException();
        }
        this.listElements.add(obj);
    }

    public Object dequeue() {
        if (this.isEmpty()) {
            throw new EmptyException();
        }
        return this.listElements.remove(0);
    }

    public Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.listElements.get(0);
    }

    public boolean isEmpty() {
        return this.listElements.size() <= 0;
    }

    public boolean isFull() {
        if (this.isFixed()) {
            return this.size() >= this.getMaxLen();
        }
        return false;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer("[");
        Iterator it = this.listElements.iterator();
        while (it.hasNext()) {
            strbuf.append(String.valueOf(it.next().toString()) + ", ");
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static class EmptyException
    extends RuntimeException {
    }

    public static class FullException
    extends RuntimeException {
    }
}

