/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.CaseInsensitiveMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PrecisionMap {
    Map mapPrecisions = new CaseInsensitiveMap(new HashMap());

    public Set asSet() {
        return this.mapPrecisions.keySet();
    }

    public String[] asArray() {
        return this.asSet().toArray(new String[0]);
    }

    public void addValue(String strFieldName, int val) {
        this.mapPrecisions.put(strFieldName, new Integer(val));
    }

    public boolean isCoarserGrained(String strAA, String strBB) {
        int valBB;
        int valAA = this.getPrecision(strAA);
        return valAA >= (valBB = this.getPrecision(strBB));
    }

    public boolean isFinerGrained(String strAA, String strBB) {
        int valBB;
        int valAA = this.getPrecision(strAA);
        return valAA <= (valBB = this.getPrecision(strBB));
    }

    public int getPrecision(String str) {
        Integer value = (Integer)this.mapPrecisions.get(str);
        if (value == null) {
            return Integer.MAX_VALUE;
        }
        return value;
    }

    public String toString() {
        return this.mapPrecisions.toString();
    }

    private static void runTestAAA() {
        PrecisionMap map = new PrecisionMap();
        map.addValue("CountryName", 120);
        map.addValue("CountryCode", 120);
        map.addValue("RegionName", 100);
        map.addValue("CityName", 80);
        map.addValue("ZipCode", 60);
        map.addValue("PlaceName", 40);
        System.out.println(map.isCoarserGrained("CountryName", "RegionName"));
        System.out.println(map.isCoarserGrained("CountryName", "CountryCode"));
        System.out.println(map.isCoarserGrained("CityName", "CountryName"));
        System.out.println(map.isFinerGrained("CountryName", "CountryCode"));
        System.out.println(map.isFinerGrained("PlaceName", "CountryName"));
        System.out.println(map.isFinerGrained("CityName", "CountryName"));
    }

    public static void main(String[] argv) throws Exception {
        PrecisionMap.runTestAAA();
    }
}

