/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.HashMapList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PatternMapCollection {
    HashMapList mapKeys = new HashMapList();
    HashMapList mapPatterns = new HashMapList();
    List listAll = new LinkedList();

    public void add(String strKey, Object obj) {
        this.mapKeys.put(strKey, obj);
    }

    public void remove(String strKey, Object obj) {
        this.mapKeys.removeKeyValue(strKey, obj);
    }

    public void clear(String strKey) {
        this.mapKeys.removeKey(strKey);
    }

    public void addPattern(String strPattern, Object obj) {
        this.mapPatterns.put(strPattern, obj);
    }

    public void removePattern(String strPattern, Object obj) {
        this.mapPatterns.removeKeyValue(strPattern, obj);
    }

    public void clearPattern(String strPattern) {
        this.mapPatterns.removeKey(strPattern);
    }

    public void addToAll(Object obj) {
        this.listAll.add(obj);
    }

    public void removeFromAll(Object obj) {
        this.listAll.remove(obj);
    }

    public void clearAll() {
        this.listAll.clear();
    }

    protected List getMatchingPatterns(String strKey) {
        LinkedList list = new LinkedList();
        Iterator it = this.mapPatterns.keySet().iterator();
        while (it.hasNext()) {
            String strPattern = (String)it.next();
            if (!strKey.matches(strPattern)) continue;
            List listTmp = (List)this.mapPatterns.get(strPattern);
            list.addAll(listTmp);
        }
        return list;
    }

    public List get(String strKey) {
        LinkedList listObjs = new LinkedList();
        Collection col = (Collection)this.mapKeys.get(strKey);
        listObjs.addAll(col);
        listObjs.addAll(this.getMatchingPatterns(strKey));
        listObjs.addAll(this.listAll);
        return listObjs;
    }

    public static PatternMapCollection getTestInstanceAAA() {
        PatternMapCollection e = new PatternMapCollection();
        e.add("key1", "norm1");
        e.add("key1", "norm2");
        e.add("key1", "norm3");
        e.add("key2", "norm4");
        e.add("key2", "norm5");
        e.add("key3", "norm6");
        e.add("key3", "norm7");
        e.addPattern(".*?1", "pattern1");
        e.addPattern("key?", "pattern2");
        e.addPattern("key?", "pattern3");
        e.addToAll("all1");
        e.addToAll("all2");
        return e;
    }

    private static void runTestAAA() {
        PatternMapCollection e = PatternMapCollection.getTestInstanceAAA();
        System.out.println(e.get("key1"));
        System.out.println();
        System.out.println(e.get("key2"));
        System.out.println();
        System.out.println(e.get("key3"));
        System.out.println();
        System.out.println(e.get("blah"));
        System.out.println();
    }

    public static void main(String[] argv) {
        PatternMapCollection.runTestAAA();
    }
}

