/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class OrderedList
implements List,
Serializable {
    LinkedList list = new LinkedList();

    private boolean isInBounds(int xx) {
        if (xx < 0) {
            return false;
        }
        int size = this.list.size();
        return xx < size;
    }

    private boolean isInBounds(int xx, int yy) {
        if (xx < 0 || yy < 0) {
            return false;
        }
        int size = this.list.size();
        return xx < size && yy < size;
    }

    public Iterator getForwardIterator() {
        return this.listIterator();
    }

    public Iterator getReverseIterator() {
        return new ReverseIterator();
    }

    public Enumeration elements() {
        return Collections.enumeration(this.list);
    }

    public void addToFront(Object obj) {
        this.add(0, obj);
    }

    public void addToBack(Object obj) {
        this.add(obj);
    }

    public synchronized void swap(int xx, int yy) {
        if (!this.isInBounds(xx, yy)) {
            return;
        }
        Object objX = this.list.get(xx);
        Object objY = this.list.get(yy);
        this.list.set(xx, objY);
        this.list.set(yy, objX);
    }

    public synchronized void moveTo(int xx, int yy) {
        if (!this.isInBounds(xx, yy)) {
            return;
        }
        if (xx < yy) {
            ++yy;
        }
        Object obj = this.list.get(xx);
        this.list.add(yy, obj);
        if (yy < xx) {
            ++xx;
        }
        this.list.remove(xx);
    }

    public synchronized void moveToFront(int xx) {
        this.moveTo(xx, 0);
    }

    public synchronized void moveToBack(int xx) {
        this.moveTo(xx, this.list.size() - 1);
    }

    public void add(int index, Object obj) {
        this.list.add(index, obj);
    }

    public boolean add(Object obj) {
        return this.list.add(obj);
    }

    public boolean addAll(Collection c) {
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.list.addAll(index, c);
    }

    public void clear() {
        this.list.clear();
    }

    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public int indexOf(Object obj) {
        return this.list.indexOf(obj);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int lastIndexOf(Object obj) {
        return this.list.lastIndexOf(obj);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    public boolean remove(Object obj) {
        return this.list.remove(obj);
    }

    public boolean removeAll(Collection c) {
        return this.list.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.list.retainAll(c);
    }

    public Object set(int index, Object obj) {
        return this.list.set(index, obj);
    }

    public int size() {
        return this.list.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    public Object clone() {
        OrderedList l = new OrderedList();
        l.list = (LinkedList)this.list.clone();
        return l;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.getForwardIterator();
        strbuf.append("[");
        while (it.hasNext()) {
            Object obj = it.next();
            strbuf.append(obj.toString());
            strbuf.append(", ");
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    class ReverseIterator
    implements Iterator {
        int index;

        ReverseIterator() {
            this.index = OrderedList.this.list.size() - 1;
        }

        public boolean hasNext() {
            return this.index >= 0;
        }

        public Object next() {
            return OrderedList.this.list.get(this.index--);
        }

        public void remove() {
            OrderedList.this.list.remove(this.index);
        }
    }
}

