/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public abstract class ObjectPool {
    ObjectPoolElement[] pool;
    int capacity;
    int numAvailable;
    int lastFreeIndex;
    String[] debugStacks;
    static StringWriter strWtr = new StringWriter(2048);
    static PrintWriter pWtr = new PrintWriter((Writer)strWtr, true);
    static int size = 30;
    static int iterations = 1000000;

    public ObjectPool() {
        this(10);
    }

    public ObjectPool(int newCapacity) {
        this.capacity = newCapacity;
        this.pool = new ObjectPoolElement[newCapacity];
        this.numAvailable = newCapacity;
        this.lastFreeIndex = 0;
        this.reinitialize();
    }

    public static ObjectPool synchronizedObjectPool(ObjectPool p) {
        return new SynchronizedObjectPool(p);
    }

    public static ObjectPool allocatingObjectPool(ObjectPool p) {
        return new AllocatingObjectPool(p);
    }

    public void printDebugStacks() {
    }

    protected abstract Object createObject();

    public int getAvailable() {
        return this.numAvailable;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Object getObject() throws EmptyException {
        if (this.numAvailable <= 0) {
            this.printDebugStacks();
            this.reset();
            throw new EmptyException();
        }
        boolean flagFound = false;
        int i = this.lastFreeIndex;
        while (i < this.pool.length && !flagFound) {
            if (this.pool[i].flagAvail) {
                flagFound = true;
                break;
            }
            ++i;
        }
        if (!flagFound) {
            i = 0;
            while (i < this.lastFreeIndex && !flagFound) {
                if (this.pool[i].flagAvail) {
                    flagFound = true;
                    break;
                }
                ++i;
            }
        }
        if (flagFound) {
            this.pool[i].flagAvail = false;
            --this.numAvailable;
            this.lastFreeIndex = (i + 1) % this.pool.length;
            return this.pool[i].obj;
        }
        return null;
    }

    public void releaseObject(Object obj) {
        int index = this.getIndex(obj);
        if (index >= 0) {
            this.pool[index].flagAvail = true;
            ++this.numAvailable;
        } else if (obj != null) {
            System.err.println(obj);
            System.err.println(new RuntimeException("Object Pool does not own this object."));
            System.err.println("HashCode:" + obj.hashCode());
            System.err.println(this.toString());
            throw new RuntimeException("Object Pool does not own this object.");
        }
    }

    private final int getIndex(Object obj) {
        int i = this.lastFreeIndex - 1;
        while (i >= 0) {
            if (this.pool[i].obj == obj) {
                return i;
            }
            --i;
        }
        i = this.pool.length - 1;
        while (i >= this.lastFreeIndex) {
            if (this.pool[i].obj == obj) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public boolean isTaken(Object obj) {
        int index = this.getIndex(obj);
        if (index >= 0) {
            return !this.pool[index].flagAvail;
        }
        return false;
    }

    public boolean isFree(Object obj) {
        int index = this.getIndex(obj);
        if (index >= 0) {
            return this.pool[index].flagAvail;
        }
        return false;
    }

    public boolean ownsObject(Object obj) {
        return this.getIndex(obj) >= 0;
    }

    public void reset() {
        int i = 0;
        while (i < this.pool.length) {
            this.pool[i].flagAvail = true;
            ++i;
        }
        this.lastFreeIndex = 0;
        this.numAvailable = this.pool.length;
    }

    public void reinitialize() {
        int i = 0;
        while (i < this.capacity) {
            this.pool[i] = new ObjectPoolElement();
            this.pool[i].obj = this.createObject();
            this.pool[i].flagAvail = true;
            ++i;
        }
        this.lastFreeIndex = 0;
        this.numAvailable = this.pool.length;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Capacity:  " + this.getCapacity());
        strbuf.append("\nAvailable: [");
        int i = 0;
        while (i < this.pool.length) {
            if (this.pool[i].flagAvail) {
                strbuf.append(String.valueOf(this.pool[i].obj.hashCode()) + ", ");
            }
            ++i;
        }
        strbuf.append("]");
        strbuf.append("\nTaken:     [");
        i = 0;
        while (i < this.pool.length) {
            if (!this.pool[i].flagAvail) {
                strbuf.append(String.valueOf(this.pool[i].obj.hashCode()) + ", ");
            }
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static void main(String[] argv) {
        Object obj;
        long start = 0L;
        long end = 0L;
        long g_start = 0L;
        long g_end = 0L;
        long g_sum = 0L;
        long r_start = 0L;
        long r_end = 0L;
        long r_sum = 0L;
        ObjectPoolPoint2D pool = new ObjectPoolPoint2D();
        int i = 0;
        while (i < iterations) {
            g_start = System.currentTimeMillis();
            obj = ((ObjectPool)pool).getObject();
            g_end = System.currentTimeMillis();
            r_start = System.currentTimeMillis();
            pool.releaseObject(obj);
            r_end = System.currentTimeMillis();
            g_sum += g_end - g_start;
            r_sum += r_end - r_start;
            ++i;
        }
        System.out.println(pool);
        System.out.println();
        System.out.println("obj pool");
        System.out.println("total time:     " + (g_sum + r_sum));
        System.out.println("unit time:      " + (double)(g_sum + r_sum) / (double)iterations);
        System.out.println("get time:       " + g_sum);
        System.out.println("get unit time:  " + (double)g_sum / (double)iterations);
        System.out.println("rel time:       " + r_sum);
        System.out.println("rel unit time:  " + (double)r_sum / (double)iterations);
        System.gc();
        start = System.currentTimeMillis();
        i = 0;
        while (i < iterations) {
            obj = ((ObjectPool)pool).createObject();
            ++i;
        }
        System.gc();
        end = System.currentTimeMillis();
        System.out.println();
        System.out.println("create new");
        System.out.println("total time: " + (end - start));
        System.out.println("unit time:  " + (double)(end - start) / (double)iterations);
    }

    public static class EmptyException
    extends RuntimeException {
    }

    public static class FullException
    extends RuntimeException {
    }

    class ObjectPoolElement {
        Object obj = null;
        boolean flagAvail = true;

        ObjectPoolElement() {
        }
    }

    static class AllocatingObjectPool
    extends ObjectPool {
        ObjectPool p;

        public AllocatingObjectPool(ObjectPool p) {
            this.p = p;
        }

        protected Object createObject() {
            return this.p.createObject();
        }

        public int getAvailable() {
            return this.p.getAvailable();
        }

        public int getCapacity() {
            return this.p.getCapacity();
        }

        public Object getObject() {
            return this.createObject();
        }

        public void releaseObject(Object obj) {
        }

        public boolean isTaken(Object obj) {
            return false;
        }

        public boolean isFree(Object obj) {
            return true;
        }

        public void reset() {
        }

        public void reinitialize() {
        }
    }

    static class SynchronizedObjectPool
    extends ObjectPool {
        ObjectPool p;

        public SynchronizedObjectPool(ObjectPool p) {
            this.p = p;
        }

        protected synchronized Object createObject() {
            return this.p.createObject();
        }

        public synchronized int getAvailable() {
            return this.p.getAvailable();
        }

        public synchronized int getCapacity() {
            return this.p.getCapacity();
        }

        public synchronized Object getObject() {
            return this.getObject();
        }

        public synchronized void releaseObject(Object obj) {
            this.p.releaseObject(obj);
        }

        public synchronized boolean isTaken(Object obj) {
            return this.p.isTaken(obj);
        }

        public synchronized boolean isFree(Object obj) {
            return this.p.isFree(obj);
        }

        public synchronized void reset() {
            this.p.reset();
        }

        public synchronized void reinitialize() {
            this.p.reinitialize();
        }
    }

    static final class UniquePoint2D
    extends Point2D.Float {
        static int counter = 0;
        int val = counter++;

        UniquePoint2D() {
        }

        public int hashCode() {
            return this.val;
        }
    }

    static final class ObjectPoolPoint2D
    extends ObjectPool {
        public ObjectPoolPoint2D() {
            super(size);
        }

        public Object createObject() {
            return new UniquePoint2D();
        }

        public Object getObject() {
            Point2D pt = (Point2D)super.getObject();
            pt.setLocation(0.0, 0.0);
            return pt;
        }
    }
}

