/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapLib {
    public static final String DEFAULT_COMMENT = "# ";
    public static final char DEFAULT_DELIMITER = '=';

    public static Map invert(Map mapToInvert) {
        HashMap mapInverted = new HashMap();
        Iterator it = mapToInvert.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = mapToInvert.get(key);
            mapInverted.put(val, key);
        }
        return mapInverted;
    }

    public static Map loadMap(String strText) {
        try {
            return MapLib.loadMap(strText, new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public static Map loadMap(String strText, Map m) {
        return MapLib.loadMap(strText, m, DEFAULT_COMMENT, '=');
    }

    public static Map loadMap(String strText, Map m, String strComment, char chDelimiter) {
        try {
            return MapLib.loadMap(new StringReader(strText), m, strComment, chDelimiter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return m;
        }
    }

    public static Map loadMap(Reader rdr) throws IOException {
        return MapLib.loadMap(rdr, new HashMap());
    }

    public static Map loadMap(Reader rdr, Map m) throws IOException {
        return MapLib.loadMap(rdr, m, DEFAULT_COMMENT, '=');
    }

    public static Map loadMap(Reader rdr, Map m, String strComment, char chDelimiter) throws IOException {
        String strLine;
        BufferedReader brdr = rdr instanceof BufferedReader ? (BufferedReader)rdr : new BufferedReader(rdr);
        while ((strLine = brdr.readLine()) != null) {
            int index;
            if (strLine.startsWith(strComment) || strLine.length() <= 0) continue;
            int startindex = index = strLine.indexOf(chDelimiter);
            if (index < 0) continue;
            int len = strLine.length();
            int i = index + 1;
            while (i < len) {
                if (strLine.charAt(i) != chDelimiter) {
                    index = i - 1;
                    break;
                }
                ++i;
            }
            String strKey = strLine.substring(0, startindex);
            String strVal = strLine.substring(index + 1);
            m.put(strKey, strVal);
        }
        return m;
    }

    public static Map loadMap(InputStream istream) throws IOException {
        return MapLib.loadMap(istream, new HashMap());
    }

    public static Map loadMap(InputStream istream, Map m) throws IOException {
        return MapLib.loadMap(istream, m, DEFAULT_COMMENT, '=');
    }

    public static Map loadMap(InputStream istream, Map m, String strComment, char chDelimiter) throws IOException {
        return MapLib.loadMap(new InputStreamReader(istream), m, strComment, chDelimiter);
    }

    public static String saveMapAsString(Map m) {
        StringWriter wtr = new StringWriter();
        MapLib.saveMapToWriter(m, wtr);
        return wtr.toString();
    }

    public static String saveMapAsString(Map m, Object[] keys) {
        StringWriter wtr = new StringWriter();
        MapLib.saveMapToWriter(m, wtr, keys);
        return wtr.toString();
    }

    public static void saveMapToWriter(Map m, Writer wtr) {
        Set setKeys = m.keySet();
        Object[] keys = setKeys.toArray();
        MapLib.saveMapToWriter(m, wtr, keys);
    }

    public static void saveMapToWriter(Map m, Writer wtr, Object[] keys) {
        try {
            int i = 0;
            while (i < keys.length) {
                String strKey = "" + keys[i];
                String strVal = "" + m.get(keys[i]);
                wtr.write(strKey);
                wtr.write("=");
                wtr.write(strVal);
                wtr.write("\n");
                ++i;
            }
            wtr.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map getTestInstanceAAA() {
        HashMap<String, String> mapTest = new HashMap<String, String>();
        mapTest.put("a", "alice");
        mapTest.put("b", "bob");
        mapTest.put("c", "carol");
        return mapTest;
    }

    private static Map getTestInstanceBBB() {
        HashMap<String, String> mapTest = new HashMap<String, String>();
        mapTest.put("a", "alice");
        mapTest.put("b", "bob");
        mapTest.put("c", "carol");
        mapTest.put("z", "alice");
        return mapTest;
    }

    private static void runTestAAA() {
        Map mapTest = MapLib.getTestInstanceAAA();
        System.out.println(mapTest);
        System.out.println(MapLib.invert(mapTest));
    }

    private static void runTestBBB() {
        Map mapAA = MapLib.getTestInstanceBBB();
        String strMap = MapLib.saveMapAsString(mapAA);
        System.out.println("===mapAA");
        System.out.println(mapAA);
        System.out.println("===strMap");
        System.out.println(strMap);
        Map mapBB = MapLib.loadMap(strMap);
        System.out.println("===mapBB");
        System.out.println(mapBB);
        System.out.println("===========================");
        Object[] objectArray = new String[4];
        objectArray[0] = "alice";
        objectArray[1] = "b";
        objectArray[2] = "";
        strMap = MapLib.saveMapAsString(mapAA, objectArray);
        System.out.println("===strMap");
        System.out.println(strMap);
        mapBB = MapLib.loadMap(strMap);
        System.out.println("===mapBB");
        System.out.println(mapBB);
    }

    public static void main(String[] argv) {
        MapLib.runTestBBB();
    }
}

