/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.util.StringLib;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Map2D {
    private Map grid = new LinkedHashMap();
    private Map colHeaders;

    public Map2D() {
        this.colHeaders = new LinkedHashMap();
    }

    public Map2D(Map2D old) {
        Set oldRowHeaders = old.getRows();
        if (oldRowHeaders != null) {
            Iterator rowIt = oldRowHeaders.iterator();
            while (rowIt.hasNext()) {
                Object rowHeader = rowIt.next();
                Map rowData = (Map)old.grid.get(rowHeader);
                this.grid.put(rowHeader, new LinkedHashMap(rowData));
            }
        }
        this.colHeaders = new LinkedHashMap(old.colHeaders);
    }

    public boolean addRow(Object header) {
        if (!this.containsRow(header)) {
            LinkedHashMap newRow = new LinkedHashMap();
            this.grid.put(header, newRow);
            return true;
        }
        return false;
    }

    public boolean containsRow(Object header) {
        return this.grid.containsKey(header);
    }

    public boolean removeRow(Object header) {
        boolean ret = this.containsRow(header);
        this.grid.remove(header);
        return ret;
    }

    public boolean renameRow(Object oldHeader, Object newHeader) {
        if (this.containsRow(oldHeader) && !this.containsRow(newHeader)) {
            this.grid.put(newHeader, this.grid.get(oldHeader));
            this.grid.remove(oldHeader);
            return true;
        }
        return false;
    }

    public boolean addCol(Object header) {
        if (!this.containsCol(header)) {
            this.colHeaders.put(header, new Object());
            return true;
        }
        return false;
    }

    public boolean containsCol(Object header) {
        return this.colHeaders.containsKey(header);
    }

    public boolean removeCol(Object header) {
        boolean ret = this.containsCol(header);
        if (ret) {
            Object realHeader = this.colHeaders.get(header);
            this.colHeaders.remove(header);
            Iterator rowIt = this.grid.keySet().iterator();
            while (rowIt.hasNext()) {
                Map row = (Map)this.grid.get(rowIt.next());
                row.remove(realHeader);
            }
        }
        return ret;
    }

    public boolean renameCol(Object oldHeader, Object newHeader) {
        if (this.containsCol(oldHeader) && !this.containsCol(newHeader)) {
            this.colHeaders.put(newHeader, this.colHeaders.get(oldHeader));
            this.colHeaders.remove(oldHeader);
            return true;
        }
        return false;
    }

    public boolean copyCol(Object fromHeader, Object toHeader) {
        Set rows = this.getRows();
        if (rows != null && this.containsCol(fromHeader) && this.containsCol(toHeader)) {
            Iterator rowIt = rows.iterator();
            while (rowIt.hasNext()) {
                Object rowHeader = rowIt.next();
                this.put(rowHeader, toHeader, this.get(rowHeader, fromHeader));
            }
            return true;
        }
        return false;
    }

    public void put(Object rowHeader, Object colHeader, Object data) {
        this.addRow(rowHeader);
        this.addCol(colHeader);
        ((Map)this.grid.get(rowHeader)).put(this.colHeaders.get(colHeader), data);
    }

    public Object get(Object rowHeader, Object colHeader) {
        Map row = (Map)this.grid.get(rowHeader);
        if (row != null) {
            return row.get(this.colHeaders.get(colHeader));
        }
        return null;
    }

    public Map getRow(Object rowHeader) {
        Map row = (Map)this.grid.get(rowHeader);
        LinkedHashMap mapTmp = new LinkedHashMap();
        Iterator it = this.colHeaders.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (row == null) {
                mapTmp.put(key, null);
                continue;
            }
            mapTmp.put(key, row.get(this.colHeaders.get(key)));
        }
        return mapTmp;
    }

    public Map getCol(Object colHeader) {
        Iterator it = this.grid.keySet().iterator();
        LinkedHashMap mapTmp = new LinkedHashMap();
        while (it.hasNext()) {
            Object key = it.next();
            mapTmp.put(key, this.get(key, colHeader));
        }
        return mapTmp;
    }

    public Set getRows() {
        return this.grid.keySet();
    }

    public int numRows() {
        return this.getRows().size();
    }

    public Object getRowHeader(int n) {
        Set setRows = this.getRows();
        Object[] arr = setRows.toArray();
        return arr[n];
    }

    public Set getCols() {
        return this.colHeaders.keySet();
    }

    public int numCols() {
        return this.getCols().size();
    }

    public Object getColHeader(int n) {
        Set setCols = this.getCols();
        Object[] arr = setCols.toArray();
        return arr[n];
    }

    public Object matchRow(Map rowData) {
        Object matchedRowHeader = this.partialMatchRow(rowData);
        if (matchedRowHeader != null) {
            if (this.getCols().size() == rowData.size()) {
                return matchedRowHeader;
            }
            return null;
        }
        return null;
    }

    public Object partialMatchRow(Map rowData) {
        Set rows = this.getRows();
        if (rows == null) {
            return null;
        }
        Iterator rowIt = rows.iterator();
        while (rowIt.hasNext()) {
            Object rowHeader = rowIt.next();
            Map row = (Map)this.grid.get(rowHeader);
            boolean match = true;
            Iterator colIt = rowData.keySet().iterator();
            while (colIt.hasNext()) {
                Object colHeader = colIt.next();
                if (row.get(colHeader).equals(rowData.get(colHeader))) continue;
                match = false;
            }
            if (!match) continue;
            return rowHeader;
        }
        return null;
    }

    public Object matchCol(Map colData) {
        Object matchedColHeader = this.partialMatchCol(colData);
        if (matchedColHeader != null) {
            if (this.getRows().size() == colData.size()) {
                return matchedColHeader;
            }
            return null;
        }
        return null;
    }

    public Object partialMatchCol(Map colData) {
        Set cols = this.getCols();
        if (cols == null) {
            return null;
        }
        Iterator colIt = cols.iterator();
        while (colIt.hasNext()) {
            Object colHeader = colIt.next();
            boolean match = true;
            Iterator rowIt = this.grid.keySet().iterator();
            while (rowIt.hasNext()) {
                Object rowHeader = rowIt.next();
                Object dataAtRowCol = this.get(rowHeader, colHeader);
                if (dataAtRowCol == null) {
                    match = colData.get(rowHeader) == null;
                    continue;
                }
                if (dataAtRowCol.equals(colData.get(rowHeader))) continue;
                match = false;
            }
            if (!match) continue;
            return colHeader;
        }
        return null;
    }

    public void clear() {
        this.grid.clear();
        this.colHeaders.clear();
    }

    public Collection values() {
        LinkedList listValues = new LinkedList();
        Iterator it = this.getRows().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Map mapTmp = (Map)this.grid.get(key);
            if (mapTmp == null) continue;
            listValues.addAll(mapTmp.values());
        }
        int numNulls = this.numRows() * this.numCols() - listValues.size();
        int i = 0;
        while (i < numNulls) {
            listValues.add(null);
            ++i;
        }
        return listValues;
    }

    public String toString() {
        Set rows;
        Iterator colIt;
        StringBuffer sb = new StringBuffer();
        Set cols = this.getCols();
        if (cols != null) {
            colIt = cols.iterator();
            sb.append('\t');
            while (colIt.hasNext()) {
                Object colHeader = colIt.next();
                sb.append(colHeader);
                sb.append('\t');
            }
            sb.append('\n');
        }
        if ((rows = this.getRows()) != null) {
            Iterator rowIt = rows.iterator();
            while (rowIt.hasNext()) {
                Object rowHeader = rowIt.next();
                sb.append(rowHeader);
                sb.append('\t');
                colIt = this.getCols().iterator();
                while (colIt.hasNext()) {
                    Object colHeader = colIt.next();
                    Object data = this.get(rowHeader, colHeader);
                    sb.append(data);
                    sb.append('\t');
                }
                sb.append('\n');
            }
        }
        if (rows == null && cols == null) {
            return "null";
        }
        return sb.toString();
    }

    public String toDebugString() {
        return this.toDebugString(1);
    }

    public String toDebugString(int colSpacing) {
        return this.toDebugString(colSpacing, true, true);
    }

    public String toDebugString(int colSpacing, boolean flagTight, boolean flagNoNull) {
        return this.toDebugString(new LinkedList(this.getRows()), new LinkedList(this.getCols()), colSpacing, flagTight, flagNoNull);
    }

    public String toDebugString(List listRowHeaders, List listColHeaders, int colSpacing, boolean flagTight, boolean flagNoNull) {
        Object colKey;
        Iterator itCols;
        StringBuffer strbuf = new StringBuffer();
        int[] colWidths = new int[this.numCols() + 1];
        int numCols = this.numCols();
        if (flagTight) {
            colWidths[0] = StringLib.calcLongestStringLen(listRowHeaders, flagNoNull);
            itCols = listColHeaders.iterator();
            int i = 0;
            while (i < numCols) {
                colKey = itCols.next();
                int widthHeader = colKey.toString().length();
                Map colTmp = this.getCol(colKey);
                int widthCol = StringLib.calcLongestStringLen(colTmp.values(), flagNoNull);
                colWidths[i + 1] = Math.max(widthHeader, widthCol);
                ++i;
            }
        } else {
            int maxRowKeyLen = StringLib.calcLongestStringLen(this.getRows(), flagNoNull);
            int maxColKeyLen = StringLib.calcLongestStringLen(this.getCols(), flagNoNull);
            int maxValLen = StringLib.calcLongestStringLen(this.values(), flagNoNull);
            int colWidth = Math.max(maxRowKeyLen, maxColKeyLen);
            colWidth = Math.max(colWidth, maxValLen);
            int i = 0;
            while (i < colWidths.length) {
                colWidths[i] = colWidth;
                ++i;
            }
        }
        int i = 0;
        while (i < colWidths.length) {
            int n = i++;
            colWidths[n] = colWidths[n] + colSpacing;
        }
        i = 1;
        itCols = listColHeaders.iterator();
        strbuf.append(StringLib.blank(colWidths[0]));
        while (itCols.hasNext()) {
            strbuf.append(StringLib.padAtEnd(itCols.next().toString(), colWidths[i++]));
        }
        Iterator itRows = listRowHeaders.iterator();
        while (itRows.hasNext()) {
            strbuf.append("\n");
            Object rowKey = itRows.next();
            Map row = this.getRow(rowKey);
            strbuf.append(StringLib.padAtEnd(rowKey.toString(), colWidths[0]));
            itCols = listColHeaders.iterator();
            i = 1;
            while (itCols.hasNext()) {
                colKey = itCols.next();
                Object val = row.get(colKey);
                String strVal = val == null ? (flagNoNull ? "" : "null") : val.toString();
                strbuf.append(StringLib.padAtEnd(strVal, colWidths[i++]));
            }
        }
        return strbuf.toString();
    }

    public Object clone() {
        return new Map2D(this);
    }

    public static Map2D getTestInstanceAAA() {
        Map2D grid = new Map2D();
        grid.put(new Integer(12345678), new Integer(1), "Long String name here!");
        grid.put(new Integer(5), new Integer(1), "Hey!");
        grid.put(new Integer(4), new Integer(2), "Hey!");
        grid.put(new Integer(4), new Integer(5), "Yo!");
        grid.put(new Integer(5), new Integer(5), "Yo!");
        return grid;
    }

    private static void runTestAAA() {
    }

    public static void main(String[] args) {
        Map2D grid = Map2D.getTestInstanceAAA();
        System.out.println(grid);
        HashMap<Integer, String> toMatch = new HashMap<Integer, String>();
        toMatch.put(new Integer(4), "Yo!");
        toMatch.put(new Integer(5), "D'oh!");
        System.out.println(grid.matchCol(toMatch));
        grid.removeCol(new Integer(2));
        System.out.println(grid);
        Map2D grid2 = new Map2D(grid);
        System.out.println("Original: ");
        System.out.println(grid);
        System.out.println("Clone: ");
        System.out.println(grid2);
        grid2.put(new Integer(4), new Integer(5), "6");
        grid2.put(new Integer(5), new Integer(2), "3");
        System.out.println("Original: ");
        System.out.println(grid);
        System.out.println("Clone: ");
        System.out.println(grid2);
        System.out.println("All values: ");
        Iterator it = grid.values().iterator();
        while (it.hasNext()) {
            System.out.println("   " + it.next());
        }
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println(grid);
        System.out.println(grid.getRow(new Integer(4)));
        System.out.println(grid.getRow(new Integer(5)));
        System.out.println(grid.getRow(new Integer(9)));
        System.out.println(grid.getCol(new Integer(1)));
        System.out.println(grid.getCol(new Integer(5)));
        System.out.println(grid.getCol(new Integer(9)));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("AAA");
        System.out.println(grid.toDebugString(1, true, true));
        System.out.println("BBB");
        System.out.println(grid.toDebugString(2, true, false));
        System.out.println("CCC");
        System.out.println(grid.toDebugString(3, false, true));
        System.out.println("DDD");
        System.out.println(grid.toDebugString(4, false, false));
        System.out.println("EEE");
        System.out.println(grid.toDebugString(2));
        System.out.println(grid.toDebugString(5));
        System.out.println(grid.toDebugString(10));
    }
}

