/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class IndexedMap
implements Map {
    HashMap mapForward = new HashMap();
    HashMap mapReverse = new HashMap();

    public IndexedMap() {
    }

    public IndexedMap(Map m) {
        this.putAll(m);
    }

    public int size() {
        return this.mapForward.size();
    }

    public boolean isEmpty() {
        return this.mapForward.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.mapForward.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.mapReverse.containsKey(value);
    }

    public Object get(Object key) {
        return this.mapForward.get(key);
    }

    public Object put(Object key, Object value) {
        this.mapForward.put(key, value);
        this.mapReverse.put(value, key);
        return value;
    }

    public Object remove(Object key) {
        Object obj = this.mapForward.remove(key);
        this.mapReverse.remove(obj);
        return obj;
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = t.get(key);
            this.put(key, val);
        }
    }

    public void clear() {
        this.mapForward.clear();
        this.mapReverse.clear();
    }

    public Set keySet() {
        return this.mapForward.keySet();
    }

    public Collection values() {
        return this.mapForward.values();
    }

    public Set entrySet() {
        return this.mapForward.entrySet();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IndexedMap)) {
            return false;
        }
        IndexedMap mapAA = this;
        IndexedMap mapBB = (IndexedMap)o;
        return mapAA.mapForward.equals(mapBB.mapForward) && mapAA.mapReverse.equals(mapBB.mapReverse);
    }

    public Object getKey(Object val) {
        return this.mapReverse.get(val);
    }

    public String toString() {
        return this.mapForward.toString();
    }

    public static void main(String[] argv) {
        IndexedMap map = new IndexedMap();
        map.put("A", "aardvark");
        map.put("B", "bear");
        map.put("C", "cut");
        map.put("D", "dog");
        map.put("E", "elephant");
        System.out.println("-----------");
        System.out.println(map);
        System.out.println();
        System.out.println("-----------");
        System.out.println(map.getKey("aardvark"));
        System.out.println(map.getKey("A"));
    }
}

