/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.HashMapCollection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class HashMapList
extends HashMapCollection {
    public HashMapList() {
    }

    public HashMapList(HashMapList m) {
        super(m);
    }

    protected Collection getNewCollectionInstance() {
        return new LinkedList();
    }

    protected Collection getNewCollectionInstance(Collection c) {
        return new LinkedList(c);
    }

    public static HashMapList getTestInstanceAAA() {
        return new HashMapList();
    }

    public static HashMapList getTestInstanceBBB() {
        HashMapList m = new HashMapList();
        m.put("A", "Alphabet");
        m.put("A", "Antwerp");
        m.put("A", "Aardvark");
        m.put("B", "Beach");
        m.put("B", "Bust");
        m.put("C", "Cookie");
        return m;
    }

    private static void runTestAAA() {
        System.out.println(HashMapList.getTestInstanceAAA());
        System.out.println("----------");
        System.out.println(HashMapList.getTestInstanceBBB());
        System.out.println("----------");
    }

    private static void runTestBBB() {
        HashMapList m = HashMapList.getTestInstanceBBB();
        System.out.println(m);
        System.out.println("--- Test 1 - add 'D', 'Dog'");
        m.put("D", "Dog");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 2 - remove 'A'");
        m.removeKey("A");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 3 - remove again (should be no effect)");
        m.removeKey("A");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 4 - get (returns a List)");
        System.out.println(m.get("D"));
        System.out.println();
        System.out.println("--- Test 5 - add 'F', 'Fox'");
        m.put("F", "Fox");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 6 - add again");
        m.put("F", "Fox");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 7 - clone");
        System.out.println(new HashMapList(m));
        System.out.println();
        System.out.println("--- Test 8 - clear");
        m.clear();
        System.out.println(m);
    }

    private static void runTestCCC() {
        HashMapList m = new HashMapList();
        m.put("A", "Alphabet");
        m.put("A", "Antwerp");
        m.put("A", "Aardvark");
        m.put("B", "Beach");
        m.put("B", "Bust");
        m.put("C", "Cookie");
        System.out.println("--- Test 0 - starting HashMapList");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 1 - add 'D', 'Dog'");
        m.put("D", "Dog");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 2 - remove 'A'");
        m.removeKey("A");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 3 - remove again (should be no effect)");
        m.removeKey("A");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 4 - add 'F', 'Fox'");
        m.put("F", "Fox");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 5 - add again");
        m.put("F", "Fox");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 6 - try to add 'C', 'Cat' to a copy");
        List list = (List)m.get("C");
        list.add("Cat");
        System.out.println(m);
        System.out.println();
        System.out.println("--- Test 7 - clone");
        System.out.println(new HashMapList(m));
        System.out.println();
        System.out.println("--- Test 8 - clear");
        m.clear();
        System.out.println(m);
    }

    public static void main(String[] argv) {
        HashMapList.runTestCCC();
    }
}

