/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class HashMapCollection {
    Map map = this.createMap();

    protected Map createMap() {
        return new HashMap();
    }

    protected abstract Collection getNewCollectionInstance();

    protected abstract Collection getNewCollectionInstance(Collection var1);

    protected Collection getCollectionInstance(Object key) {
        Object val = this.map.get(key);
        if (val == null) {
            return this.getNewCollectionInstance();
        }
        return (Collection)val;
    }

    public HashMapCollection() {
    }

    public HashMapCollection(HashMapCollection m) {
        HashMapCollection mapOrig = m;
        HashMapCollection mapCopy = this;
        Iterator it = mapOrig.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Collection c = (Collection)mapOrig.get(key);
            mapCopy.map.put(key, this.getNewCollectionInstance(c));
        }
    }

    public int size(Object key) {
        Collection c = this.getCollectionInstance(key);
        return c.size();
    }

    public boolean isEmpty(Object key) {
        return this.size(key) <= 0;
    }

    public boolean containsKeyValue(Object key, Object value) {
        Collection c = this.getCollectionInstance(key);
        return c.contains(value);
    }

    public Object get(Object key) {
        return this.getNewCollectionInstance(this.getCollectionInstance(key));
    }

    public void removeKeyValue(Object key, Object val) {
        Collection c = this.getCollectionInstance(key);
        c.remove(val);
    }

    public Object removeKey(Object key) {
        Collection c = this.getCollectionInstance(key);
        this.map.remove(key);
        return c;
    }

    public Object put(Object key, Object value) {
        Collection c = this.getCollectionInstance(key);
        c.add(value);
        this.map.put(key, c);
        return null;
    }

    public int sizeKeys() {
        return this.map.size();
    }

    public int sizeValues() {
        int size = 0;
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Collection c = this.getCollectionInstance(it.next());
            size += c.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public void removeValue(Object val) {
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            this.removeKeyValue(it.next(), val);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        Iterator it = this.keySet().iterator();
        LinkedList listValues = new LinkedList();
        while (it.hasNext()) {
            Collection c = this.getCollectionInstance(it.next());
            listValues.addAll(c);
        }
        return this.values();
    }

    public void setCollection(Object key, Collection value) {
        this.map.put(key, value);
    }

    public Collection getCollection(Object key) {
        return (Collection)this.map.get(key);
    }

    public String toString() {
        return this.map.toString();
    }
}

