/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashBag {
    HashMap map = new HashMap();

    public int add(Object obj) {
        ModifiableInteger mint = (ModifiableInteger)this.map.get(obj);
        if (mint == null) {
            mint = new ModifiableInteger();
            this.map.put(obj, mint);
        }
        ++mint.val;
        return mint.val;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isEmpty(Object obj) {
        return this.size(obj) == 0;
    }

    public Iterator iterator() {
        return new BagIterator();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public int remove(Object obj) {
        ModifiableInteger mint = (ModifiableInteger)this.map.get(obj);
        if (mint == null) {
            return 0;
        }
        if (mint.val > 0) {
            --mint.val;
        }
        if (mint.val == 0) {
            this.map.remove(obj);
        }
        return mint.val;
    }

    public int size() {
        int count = 0;
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            ModifiableInteger mint = (ModifiableInteger)it.next();
            count += mint.val;
        }
        return count;
    }

    public int sizeKeySet() {
        return this.map.size();
    }

    public int size(Object obj) {
        ModifiableInteger mint = (ModifiableInteger)this.map.get(obj);
        if (mint == null) {
            return 0;
        }
        return mint.val;
    }

    public String toString() {
        return this.map.toString();
    }

    class ModifiableInteger {
        int val = 0;

        ModifiableInteger() {
        }

        public String toString() {
            return Integer.toString(this.val);
        }
    }

    class BagIterator
    implements Iterator {
        Iterator keyIt;
        Object obj;
        int count;

        BagIterator() {
            this.keyIt = HashBag.this.keySet().iterator();
            this.count = 0;
        }

        private void getNextBunch() {
            this.obj = this.keyIt.next();
            ModifiableInteger mint = (ModifiableInteger)HashBag.this.map.get(this.obj);
            this.count = mint.val;
        }

        public boolean hasNext() {
            return this.keyIt.hasNext() || this.count > 0;
        }

        public Object next() {
            if (this.count == 0) {
                this.getNextBunch();
            }
            --this.count;
            return this.obj;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

