/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.collection;

import edu.berkeley.guir.lib.collection.MapLib;
import edu.berkeley.guir.lib.collection.MapWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CaseInsensitiveMap
extends MapWrapper {
    Map mapKeys = new HashMap();

    public CaseInsensitiveMap() {
        super(new HashMap());
    }

    public CaseInsensitiveMap(Map map) {
        this();
        this.putAll(map);
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String strKey = (String)key;
            return this.mapKeys.containsKey(strKey.toLowerCase());
        }
        return super.containsKey(key);
    }

    public Object put(Object key, Object val) {
        if (key instanceof String) {
            String strKey = (String)key;
            this.mapKeys.put(strKey.toLowerCase(), strKey);
        }
        return super.put(key, val);
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = t.get(key);
            this.put(key, val);
        }
    }

    public Object get(Object key) {
        if (key instanceof String) {
            key = this.mapKeys.get(((String)key).toLowerCase());
        }
        return super.get(key);
    }

    public Object remove(Object key) {
        if (key instanceof String) {
            String strKeyAA = (String)key;
            key = this.mapKeys.remove(strKeyAA.toLowerCase());
        }
        return super.remove(key);
    }

    public String toDebugString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.getWrappedMap().toString());
        strbuf.append("\n");
        strbuf.append(this.mapKeys.toString());
        return strbuf.toString();
    }

    private static Map getMapAAA() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("HI", "THERE");
        map.put("AA", "BB");
        map.put("Ccc", "zzzzz");
        return map;
    }

    private static Map getMapBBB() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("DELETE", "REMOVE");
        map.put("POST", "ADD");
        map.put("UPDATE", "UPDATE");
        map.put("GET", "QUERY");
        map.put("UNSUBSCRIBE", "UNSUBSCRIBE");
        map.put("ADDSPC", "ADDSPC");
        map.put("REMOVESPC", "REMOVESPC");
        map.put("SUBSCRIBE", "SUBSCRIBE");
        map.put("NOTIFY", "NOTIFY");
        return map;
    }

    private static Map getMapCCC() {
        return MapLib.invert(CaseInsensitiveMap.getMapBBB());
    }

    private static void runTestAAA() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("CCC", "DDD");
        map.put("eeE", "fff");
        map.put("ggg", "hhH");
        System.out.println(map);
        System.out.println();
        map.putAll(CaseInsensitiveMap.getMapAAA());
        System.out.println(map);
        System.out.println();
        System.out.println(map.get("CCC"));
        System.out.println(map.get("Ccc"));
        System.out.println(map.get("ccc"));
        System.out.println("------");
        System.out.println(map);
        System.out.println(map.mapKeys);
        System.out.println("------");
        System.out.println(map.remove("ccc"));
        System.out.println(map.get("ccc"));
        System.out.println("------");
        System.out.println(map);
        System.out.println(map.mapKeys);
    }

    private static void runTestBBB() {
        CaseInsensitiveMap map = new CaseInsensitiveMap(CaseInsensitiveMap.getMapBBB());
        System.out.println(map);
        System.out.println(map.get("POST"));
        System.out.println(map.get("Post"));
        System.out.println(map.get("DELETE"));
        System.out.println(map.get("NOTIFY"));
        System.out.println(map.get("UPDATE"));
    }

    private static void runTestCCC() {
        CaseInsensitiveMap map = new CaseInsensitiveMap(CaseInsensitiveMap.getMapCCC());
        System.out.println(map);
        System.out.println(map.get("ADD"));
        System.out.println(map.get("Add"));
        System.out.println(map.get("REMOVE"));
        System.out.println(map.get("Query"));
    }

    private static void main(String[] argv) {
        CaseInsensitiveMap.runTestCCC();
    }
}

